/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Clock;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.mailbox.tools.indexer.MessageIdReIndexingTask;

public class MessageIdReindexingTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final String messageId;
    private final Instant timestamp;

    public static AdditionalInformationDTOModule<MessageIdReIndexingTask.AdditionalInformation, MessageIdReindexingTaskAdditionalInformationDTO> module(MessageId.Factory factory) {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(MessageIdReIndexingTask.AdditionalInformation.class).convertToDTO(MessageIdReindexingTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new MessageIdReIndexingTask.AdditionalInformation(factory.fromString(dto.getMessageId()), dto.timestamp)).toDTOConverter((details, type) -> new MessageIdReindexingTaskAdditionalInformationDTO(type, details.getMessageId(), details.timestamp())).typeName(MessageIdReIndexingTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private MessageIdReindexingTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="messageId") String messageId, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.messageId = messageId;
        this.timestamp = timestamp;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return this.type;
    }

    public static MessageIdReindexingTaskAdditionalInformationDTO of(MessageIdReIndexingTask task) {
        return new MessageIdReindexingTaskAdditionalInformationDTO(task.type().asString(), task.getMessageId().serialize(), Clock.systemUTC().instant());
    }
}

