/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.Command;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.RpcWrapper;
import java.util.concurrent.CompletableFuture;

public class CompletableFutureRpcWrapper
implements RpcWrapper {
    private final Method request;
    private final CompletableFuture<Command> completableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> completableFuture) {
        this.request = method;
        this.completableFuture = completableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand command) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
    }

    @Override
    public void complete(AMQCommand command) {
        this.completableFuture.complete(command);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        this.completableFuture.completeExceptionally(signal);
    }
}

