/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.core.quota;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.core.quota.QuotaType;

public class QuotaCurrentValue {
    private final QuotaComponent quotaComponent;
    private final String identifier;
    private final QuotaType quotaType;
    private final long currentValue;

    public static Builder builder() {
        return new Builder();
    }

    private QuotaCurrentValue(QuotaComponent quotaComponent, String identifier, QuotaType quotaType, long currentValue) {
        this.quotaComponent = quotaComponent;
        this.identifier = identifier;
        this.quotaType = quotaType;
        this.currentValue = currentValue;
    }

    public QuotaComponent getQuotaComponent() {
        return this.quotaComponent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public QuotaType getQuotaType() {
        return this.quotaType;
    }

    public long getCurrentValue() {
        return this.currentValue;
    }

    public final int hashCode() {
        return Objects.hash(this.quotaComponent, this.identifier, this.quotaType, this.currentValue);
    }

    public final boolean equals(Object o) {
        if (o instanceof QuotaCurrentValue) {
            QuotaCurrentValue other = (QuotaCurrentValue)o;
            return Objects.equals(this.quotaComponent, other.quotaComponent) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.quotaType, other.quotaType) && Objects.equals(this.currentValue, other.currentValue);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quotaComponent", (Object)this.quotaComponent).add("identifier", (Object)this.identifier).add("quotaType", (Object)this.quotaType).add("currentValue", this.currentValue).toString();
    }

    public static class Builder {
        private QuotaComponent quotaComponent;
        private String identifier;
        private QuotaType quotaType;
        private long currentValue;

        public Builder quotaComponent(QuotaComponent quotaComponent) {
            this.quotaComponent = quotaComponent;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder quotaType(QuotaType quotaType) {
            this.quotaType = quotaType;
            return this;
        }

        public Builder currentValue(long currentValue) {
            this.currentValue = currentValue;
            return this;
        }

        public QuotaCurrentValue build() {
            Preconditions.checkState((this.quotaComponent != null ? 1 : 0) != 0, (Object)"`quotaComponent` is mandatory");
            Preconditions.checkState((this.identifier != null ? 1 : 0) != 0, (Object)"`identifier` is mandatory");
            Preconditions.checkState((this.quotaType != null ? 1 : 0) != 0, (Object)"`quotaType` is mandatory");
            return new QuotaCurrentValue(this.quotaComponent, this.identifier, this.quotaType, this.currentValue);
        }
    }

    public static class Key {
        private final QuotaComponent quotaComponent;
        private final String identifier;
        private final QuotaType quotaType;

        public static Key of(QuotaComponent component, String identifier, QuotaType quotaType) {
            return new Key(component, identifier, quotaType);
        }

        public QuotaComponent getQuotaComponent() {
            return this.quotaComponent;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public QuotaType getQuotaType() {
            return this.quotaType;
        }

        private Key(QuotaComponent quotaComponent, String identifier, QuotaType quotaType) {
            this.quotaComponent = quotaComponent;
            this.identifier = identifier;
            this.quotaType = quotaType;
        }

        public final int hashCode() {
            return Objects.hash(this.quotaComponent, this.identifier, this.quotaType);
        }

        public final boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return Objects.equals(this.quotaComponent, other.quotaComponent) && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.quotaType, other.quotaType);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("quotaComponent", (Object)this.quotaComponent).add("identifier", (Object)this.identifier).add("quotaType", (Object)this.quotaType).toString();
        }
    }
}

