/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.quota.QuotaComponent;
import org.apache.james.mailbox.quota.task.RecomputeCurrentQuotasService;

public class RunningOptionsDTO {
    private final Optional<Integer> usersPerSecond;
    private final List<String> quotaComponents;

    public static RunningOptionsDTO asDTO(RecomputeCurrentQuotasService.RunningOptions domainObject) {
        return new RunningOptionsDTO(Optional.of(domainObject.getUsersPerSecond()), (List)domainObject.getQuotaComponents().stream().map(QuotaComponent::getValue).collect(ImmutableList.toImmutableList()));
    }

    @JsonCreator
    public RunningOptionsDTO(@JsonProperty(value="usersPerSecond") Optional<Integer> usersPerSecond, @JsonProperty(value="quotaComponents") List<String> quotaComponents) {
        this.usersPerSecond = usersPerSecond;
        this.quotaComponents = quotaComponents;
    }

    public Optional<Integer> getUsersPerSecond() {
        return this.usersPerSecond;
    }

    public List<String> getQuotaComponents() {
        return this.quotaComponents;
    }

    public RecomputeCurrentQuotasService.RunningOptions asDomainObject() {
        return RecomputeCurrentQuotasService.RunningOptions.of(this.usersPerSecond.orElse(1), (List)this.quotaComponents.stream().map(QuotaComponent::of).collect(ImmutableList.toImmutableList()));
    }
}

