/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.postgres.projections;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.postgres.projections.PostgresEmailQueryViewDAO;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.util.streams.Limit;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresEmailQueryView
implements EmailQueryView {
    private PostgresEmailQueryViewDAO emailQueryViewDAO;

    @Inject
    public PostgresEmailQueryView(PostgresEmailQueryViewDAO emailQueryViewDAO) {
        this.emailQueryViewDAO = emailQueryViewDAO;
    }

    public Flux<MessageId> listMailboxContentSortedBySentAt(MailboxId mailboxId, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentSortedBySentAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), limit);
    }

    public Flux<MessageId> listMailboxContentSortedByReceivedAt(MailboxId mailboxId, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentSortedByReceivedAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), limit);
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedBySentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentSinceAfterSortedBySentAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), since, limit);
    }

    public Flux<MessageId> listMailboxContentSinceAfterSortedByReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentSinceAfterSortedByReceivedAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), since, limit);
    }

    public Flux<MessageId> listMailboxContentBeforeSortedByReceivedAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentBeforeSortedByReceivedAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), since, limit);
    }

    public Flux<MessageId> listMailboxContentSinceSentAt(MailboxId mailboxId, ZonedDateTime since, Limit limit) {
        return this.emailQueryViewDAO.listMailboxContentSinceSentAt((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), since, limit);
    }

    public Mono<Void> delete(MailboxId mailboxId, MessageId messageId) {
        return this.emailQueryViewDAO.delete((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), (PostgresMessageId)PostgresMessageId.class.cast(messageId));
    }

    public Mono<Void> delete(MailboxId mailboxId) {
        return this.emailQueryViewDAO.delete((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId));
    }

    public Mono<Void> save(MailboxId mailboxId, ZonedDateTime sentAt, ZonedDateTime receivedAt, MessageId messageId) {
        return this.emailQueryViewDAO.save((PostgresMailboxId)PostgresMailboxId.class.cast(mailboxId), sentAt, receivedAt, (PostgresMessageId)PostgresMessageId.class.cast(messageId));
    }
}

