/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.github.fge.lambdas.Throwing;
import com.google.inject.Inject;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.Startables;

public class InitializationOperations {
    private final Set<InitializationOperation> initializationOperations;
    private final Startables startables;

    @Inject
    public InitializationOperations(Set<InitializationOperation> initializationOperations, Startables startables) {
        this.initializationOperations = initializationOperations;
        this.startables = startables;
    }

    public void initModules() {
        Set<InitializationOperation> processed = this.processStartables();
        this.processOthers(processed);
    }

    private Set<InitializationOperation> processStartables() {
        return this.startables.get().stream().flatMap(this::configurationPerformerFor).distinct().sorted((a, b) -> Integer.compare(b.priority(), a.priority())).peek(Throwing.consumer(InitializationOperation::initModule).sneakyThrow()).collect(Collectors.toSet());
    }

    private Stream<InitializationOperation> configurationPerformerFor(Class<?> startable) {
        return this.initializationOperations.stream().filter(x -> startable.isAssignableFrom(x.forClass())).flatMap(x -> Stream.concat(x.requires().stream().flatMap(this::configurationPerformerFor), Stream.of(x)));
    }

    private void processOthers(Set<InitializationOperation> processed) {
        this.initializationOperations.stream().filter(x -> !processed.contains(x)).forEach(Throwing.consumer(InitializationOperation::initModule).sneakyThrow());
    }
}

