/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.filtering.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.Command;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.jmap.api.filtering.Version;

public class DefineRulesCommand
implements Command {
    private final Username username;
    private final List<Rule> rules;
    private final Optional<Version> ifInState;

    public DefineRulesCommand(Username username, List<Rule> rules, Optional<Version> ifInState) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull(rules);
        this.username = username;
        this.rules = rules;
        this.ifInState = ifInState;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public Optional<Version> getIfInState() {
        return this.ifInState;
    }

    public Username getUsername() {
        return this.username;
    }

    public final boolean equals(Object o) {
        if (o instanceof DefineRulesCommand) {
            DefineRulesCommand that = (DefineRulesCommand)o;
            return Objects.equals(this.username, that.username) && Objects.equals(this.rules, that.rules) && Objects.equals(this.ifInState, that.ifInState);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.username, this.rules, this.ifInState);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("user", (Object)this.username).add("rules", this.rules).add("ifInState", this.ifInState).toString();
    }
}

