/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights.schema;

import com.datastax.dse.driver.internal.core.insights.schema.AuthProviderType;
import com.datastax.dse.driver.internal.core.insights.schema.InsightsPlatformInfo;
import com.datastax.dse.driver.internal.core.insights.schema.PoolSizeByHostDistance;
import com.datastax.dse.driver.internal.core.insights.schema.ReconnectionPolicyInfo;
import com.datastax.dse.driver.internal.core.insights.schema.SSL;
import com.datastax.dse.driver.internal.core.insights.schema.SpecificExecutionProfile;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InsightsStartupData {
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="sessionId")
    private final String sessionId;
    @JsonProperty(value="applicationName")
    private final String applicationName;
    @JsonProperty(value="applicationVersion")
    private final String applicationVersion;
    @JsonProperty(value="contactPoints")
    private final Map<String, List<String>> contactPoints;
    @JsonProperty(value="initialControlConnection")
    private final String initialControlConnection;
    @JsonProperty(value="protocolVersion")
    private final int protocolVersion;
    @JsonProperty(value="localAddress")
    private final String localAddress;
    @JsonProperty(value="executionProfiles")
    private final Map<String, SpecificExecutionProfile> executionProfiles;
    @JsonProperty(value="poolSizeByHostDistance")
    private final PoolSizeByHostDistance poolSizeByHostDistance;
    @JsonProperty(value="heartbeatInterval")
    private final long heartbeatInterval;
    @JsonProperty(value="compression")
    private final String compression;
    @JsonProperty(value="reconnectionPolicy")
    private final ReconnectionPolicyInfo reconnectionPolicy;
    @JsonProperty(value="ssl")
    private final SSL ssl;
    @JsonProperty(value="authProvider")
    private final AuthProviderType authProvider;
    @JsonProperty(value="otherOptions")
    private final Map<String, Object> otherOptions;
    @JsonProperty(value="configAntiPatterns")
    private final Map<String, String> configAntiPatterns;
    @JsonProperty(value="periodicStatusInterval")
    private final long periodicStatusInterval;
    @JsonProperty(value="platformInfo")
    private final InsightsPlatformInfo platformInfo;
    @JsonProperty(value="hostName")
    private final String hostName;
    @JsonProperty(value="driverName")
    private String driverName;
    @JsonProperty(value="applicationNameWasGenerated")
    private boolean applicationNameWasGenerated;
    @JsonProperty(value="driverVersion")
    private String driverVersion;
    @JsonProperty(value="dataCenters")
    private Set<String> dataCenters;

    @JsonCreator
    private InsightsStartupData(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="applicationName") String applicationName, @JsonProperty(value="applicationVersion") String applicationVersion, @JsonProperty(value="contactPoints") Map<String, List<String>> contactPoints, @JsonProperty(value="initialControlConnection") String initialControlConnection, @JsonProperty(value="protocolVersion") int protocolVersion, @JsonProperty(value="localAddress") String localAddress, @JsonProperty(value="executionProfiles") Map<String, SpecificExecutionProfile> executionProfiles, @JsonProperty(value="poolSizeByHostDistance") PoolSizeByHostDistance poolSizeByHostDistance, @JsonProperty(value="heartbeatInterval") long heartbeatInterval, @JsonProperty(value="compression") String compression, @JsonProperty(value="reconnectionPolicy") ReconnectionPolicyInfo reconnectionPolicy, @JsonProperty(value="ssl") SSL ssl, @JsonProperty(value="authProvider") AuthProviderType authProvider, @JsonProperty(value="otherOptions") Map<String, Object> otherOptions, @JsonProperty(value="configAntiPatterns") Map<String, String> configAntiPatterns, @JsonProperty(value="periodicStatusInterval") long periodicStatusInterval, @JsonProperty(value="platformInfo") InsightsPlatformInfo platformInfo, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="driverName") String driverName, @JsonProperty(value="applicationNameWasGenerated") boolean applicationNameWasGenerated, @JsonProperty(value="driverVersion") String driverVersion, @JsonProperty(value="dataCenters") Set<String> dataCenters) {
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.contactPoints = contactPoints;
        this.initialControlConnection = initialControlConnection;
        this.protocolVersion = protocolVersion;
        this.localAddress = localAddress;
        this.executionProfiles = executionProfiles;
        this.poolSizeByHostDistance = poolSizeByHostDistance;
        this.heartbeatInterval = heartbeatInterval;
        this.compression = compression;
        this.reconnectionPolicy = reconnectionPolicy;
        this.ssl = ssl;
        this.authProvider = authProvider;
        this.otherOptions = otherOptions;
        this.configAntiPatterns = configAntiPatterns;
        this.periodicStatusInterval = periodicStatusInterval;
        this.platformInfo = platformInfo;
        this.hostName = hostName;
        this.driverName = driverName;
        this.applicationNameWasGenerated = applicationNameWasGenerated;
        this.driverVersion = driverVersion;
        this.dataCenters = dataCenters;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public Map<String, List<String>> getContactPoints() {
        return this.contactPoints;
    }

    public String getInitialControlConnection() {
        return this.initialControlConnection;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public Map<String, SpecificExecutionProfile> getExecutionProfiles() {
        return this.executionProfiles;
    }

    public PoolSizeByHostDistance getPoolSizeByHostDistance() {
        return this.poolSizeByHostDistance;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public String getCompression() {
        return this.compression;
    }

    public ReconnectionPolicyInfo getReconnectionPolicy() {
        return this.reconnectionPolicy;
    }

    public SSL getSsl() {
        return this.ssl;
    }

    public AuthProviderType getAuthProvider() {
        return this.authProvider;
    }

    public Map<String, Object> getOtherOptions() {
        return this.otherOptions;
    }

    public Map<String, String> getConfigAntiPatterns() {
        return this.configAntiPatterns;
    }

    public long getPeriodicStatusInterval() {
        return this.periodicStatusInterval;
    }

    public InsightsPlatformInfo getPlatformInfo() {
        return this.platformInfo;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public boolean isApplicationNameWasGenerated() {
        return this.applicationNameWasGenerated;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public Set<String> getDataCenters() {
        return this.dataCenters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clientId;
        private String sessionId;
        private String applicationName;
        private String applicationVersion;
        private Map<String, List<String>> contactPoints;
        private String initialControlConnection;
        private int protocolVersion;
        private String localAddress;
        private Map<String, SpecificExecutionProfile> executionProfiles;
        private PoolSizeByHostDistance poolSizeByHostDistance;
        private long heartbeatInterval;
        private String compression;
        private ReconnectionPolicyInfo reconnectionPolicy;
        private SSL ssl;
        private AuthProviderType authProvider;
        private Map<String, Object> otherOptions;
        private Map<String, String> configAntiPatterns;
        private long periodicStatusInterval;
        private InsightsPlatformInfo platformInfo;
        private String hostName;
        private String driverName;
        private String driverVersion;
        private boolean applicationNameWasGenerated;
        private Set<String> dataCenters;

        public InsightsStartupData build() {
            return new InsightsStartupData(this.clientId, this.sessionId, this.applicationName, this.applicationVersion, this.contactPoints, this.initialControlConnection, this.protocolVersion, this.localAddress, this.executionProfiles, this.poolSizeByHostDistance, this.heartbeatInterval, this.compression, this.reconnectionPolicy, this.ssl, this.authProvider, this.otherOptions, this.configAntiPatterns, this.periodicStatusInterval, this.platformInfo, this.hostName, this.driverName, this.applicationNameWasGenerated, this.driverVersion, this.dataCenters);
        }

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withSessionId(String id) {
            this.sessionId = id;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder withApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public Builder withContactPoints(Map<String, List<String>> contactPoints) {
            this.contactPoints = contactPoints;
            return this;
        }

        public Builder withInitialControlConnection(String inetSocketAddress) {
            this.initialControlConnection = inetSocketAddress;
            return this;
        }

        public Builder withProtocolVersion(int protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder withLocalAddress(String localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public Builder withExecutionProfiles(Map<String, SpecificExecutionProfile> executionProfiles) {
            this.executionProfiles = executionProfiles;
            return this;
        }

        public Builder withPoolSizeByHostDistance(PoolSizeByHostDistance poolSizeByHostDistance) {
            this.poolSizeByHostDistance = poolSizeByHostDistance;
            return this;
        }

        public Builder withHeartbeatInterval(long heartbeatInterval) {
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        public Builder withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicyInfo reconnectionPolicy) {
            this.reconnectionPolicy = reconnectionPolicy;
            return this;
        }

        public Builder withSsl(SSL ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder withAuthProvider(AuthProviderType authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder withOtherOptions(Map<String, Object> otherOptions) {
            this.otherOptions = otherOptions;
            return this;
        }

        public Builder withConfigAntiPatterns(Map<String, String> configAntiPatterns) {
            this.configAntiPatterns = configAntiPatterns;
            return this;
        }

        public Builder withPeriodicStatusInterval(long periodicStatusInterval) {
            this.periodicStatusInterval = periodicStatusInterval;
            return this;
        }

        public Builder withPlatformInfo(InsightsPlatformInfo insightsPlatformInfo) {
            this.platformInfo = insightsPlatformInfo;
            return this;
        }

        public Builder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder withDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder withDriverVersion(String driverVersion) {
            this.driverVersion = driverVersion;
            return this;
        }

        public Builder withApplicationNameWasGenerated(boolean applicationNameWasGenerated) {
            this.applicationNameWasGenerated = applicationNameWasGenerated;
            return this;
        }

        public Builder withDataCenters(Set<String> dataCenters) {
            this.dataCenters = dataCenters;
            return this;
        }
    }
}

