/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing.eventstore.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.james.backends.postgres.utils.PostgresUtils;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.eventsourcing.eventstore.postgres.PostgresEventStoreDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import scala.collection.Iterable;
import scala.jdk.javaapi.CollectionConverters;

public class PostgresEventStore
implements EventStore {
    private final PostgresEventStoreDAO eventStoreDAO;

    @Inject
    public PostgresEventStore(PostgresEventStoreDAO eventStoreDAO) {
        this.eventStoreDAO = eventStoreDAO;
    }

    public Publisher<Void> appendAll(Iterable<Event> scalaEvents) {
        if (scalaEvents.isEmpty()) {
            return Mono.empty();
        }
        Preconditions.checkArgument((boolean)Event.belongsToSameAggregate(scalaEvents));
        ImmutableList events = ImmutableList.copyOf((java.lang.Iterable)CollectionConverters.asJava(scalaEvents));
        Optional<EventId> snapshotId = events.stream().filter(Event::isASnapshot).map(Event::eventId).findFirst();
        return this.eventStoreDAO.appendAll((List<Event>)events, snapshotId).onErrorMap(PostgresUtils.UNIQUE_CONSTRAINT_VIOLATION_PREDICATE, e -> new EventStoreFailedException("Concurrent update to the EventStore detected"));
    }

    public Publisher<History> getEventsOfAggregate(AggregateId aggregateId) {
        return this.eventStoreDAO.getSnapshot(aggregateId).flatMap(snapshotId -> this.eventStoreDAO.getEventsOfAggregate(aggregateId, (EventId)snapshotId)).flatMap(history -> {
            if (history.getEventsJava().isEmpty()) {
                return Mono.from(this.eventStoreDAO.getEventsOfAggregate(aggregateId));
            }
            return Mono.just((Object)history);
        }).defaultIfEmpty((Object)History.empty());
    }

    public Publisher<Void> remove(AggregateId aggregateId) {
        return this.eventStoreDAO.delete(aggregateId);
    }
}

