/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres;

import jakarta.inject.Inject;
import java.util.Set;
import java.util.function.Function;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.MessageRepresentation;
import org.apache.james.mailbox.postgres.mail.dao.PostgresAttachmentDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMessageDAO;
import org.apache.james.mailbox.postgres.mail.dao.PostgresThreadDAO;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeleteMessageListener
implements EventListener.ReactiveGroupEventListener {
    public static final int LOW_CONCURRENCY = 4;
    private final BlobStore blobStore;
    private final Set<DeletionCallback> deletionCallbackList;
    private final PostgresMessageDAO.Factory messageDAOFactory;
    private final PostgresMailboxMessageDAO.Factory mailboxMessageDAOFactory;
    private final PostgresAttachmentDAO.Factory attachmentDAOFactory;
    private final PostgresThreadDAO.Factory threadDAOFactory;

    @Inject
    public DeleteMessageListener(BlobStore blobStore, PostgresMailboxMessageDAO.Factory mailboxMessageDAOFactory, PostgresMessageDAO.Factory messageDAOFactory, PostgresAttachmentDAO.Factory attachmentDAOFactory, PostgresThreadDAO.Factory threadDAOFactory, Set<DeletionCallback> deletionCallbackList) {
        this.messageDAOFactory = messageDAOFactory;
        this.mailboxMessageDAOFactory = mailboxMessageDAOFactory;
        this.blobStore = blobStore;
        this.deletionCallbackList = deletionCallbackList;
        this.attachmentDAOFactory = attachmentDAOFactory;
        this.threadDAOFactory = threadDAOFactory;
    }

    public Group getDefaultGroup() {
        return new DeleteMessageListenerGroup();
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.Expunged || event instanceof MailboxEvents.MailboxDeletion;
    }

    public Publisher<Void> reactiveEvent(Event event) {
        if (event instanceof MailboxEvents.Expunged) {
            MailboxEvents.Expunged expunged = (MailboxEvents.Expunged)event;
            return this.handleMessageDeletion(expunged);
        }
        if (event instanceof MailboxEvents.MailboxDeletion) {
            MailboxEvents.MailboxDeletion mailboxDeletion = (MailboxEvents.MailboxDeletion)event;
            return this.handleMailboxDeletion(mailboxDeletion);
        }
        return Mono.empty();
    }

    private Mono<Void> handleMailboxDeletion(MailboxEvents.MailboxDeletion event) {
        PostgresMessageDAO postgresMessageDAO = this.messageDAOFactory.create(event.getUsername().getDomainPart());
        PostgresMailboxMessageDAO postgresMailboxMessageDAO = this.mailboxMessageDAOFactory.create(event.getUsername().getDomainPart());
        PostgresAttachmentDAO attachmentDAO = this.attachmentDAOFactory.create(event.getUsername().getDomainPart());
        PostgresThreadDAO threadDAO = this.threadDAOFactory.create(event.getUsername().getDomainPart());
        return postgresMailboxMessageDAO.deleteByMailboxId((PostgresMailboxId)event.getMailboxId()).flatMap(msgId -> this.handleMessageDeletion(postgresMessageDAO, postgresMailboxMessageDAO, attachmentDAO, threadDAO, (PostgresMessageId)msgId, event.getMailboxId(), event.getMailboxPath().getUser()), 4).then();
    }

    private Mono<Void> handleMessageDeletion(MailboxEvents.Expunged event) {
        PostgresMessageDAO postgresMessageDAO = this.messageDAOFactory.create(event.getUsername().getDomainPart());
        PostgresMailboxMessageDAO postgresMailboxMessageDAO = this.mailboxMessageDAOFactory.create(event.getUsername().getDomainPart());
        PostgresAttachmentDAO attachmentDAO = this.attachmentDAOFactory.create(event.getUsername().getDomainPart());
        PostgresThreadDAO threadDAO = this.threadDAOFactory.create(event.getUsername().getDomainPart());
        return Flux.fromIterable(event.getExpunged().values()).map(MessageMetaData::getMessageId).map(PostgresMessageId.class::cast).flatMap(msgId -> this.handleMessageDeletion(postgresMessageDAO, postgresMailboxMessageDAO, attachmentDAO, threadDAO, (PostgresMessageId)msgId, event.getMailboxId(), event.getMailboxPath().getUser()), 4).then();
    }

    private Mono<Void> handleMessageDeletion(PostgresMessageDAO postgresMessageDAO, PostgresMailboxMessageDAO postgresMailboxMessageDAO, PostgresAttachmentDAO attachmentDAO, PostgresThreadDAO threadDAO, PostgresMessageId messageId, MailboxId mailboxId, Username owner) {
        return Mono.just((Object)messageId).filterWhen(msgId -> this.isUnreferenced((PostgresMessageId)msgId, postgresMailboxMessageDAO)).flatMap(msgId -> postgresMessageDAO.retrieveMessage(messageId).flatMap(this.executeDeletionCallbacks(mailboxId, owner)).then(this.deleteBodyBlob((PostgresMessageId)msgId, postgresMessageDAO)).then(this.deleteAttachment((PostgresMessageId)msgId, attachmentDAO)).then(threadDAO.deleteSome(owner, (PostgresMessageId)msgId)).then(postgresMessageDAO.deleteByMessageId((PostgresMessageId)msgId)));
    }

    private Function<MessageRepresentation, Mono<Void>> executeDeletionCallbacks(MailboxId mailboxId, Username owner) {
        return messageRepresentation -> Flux.fromIterable(this.deletionCallbackList).concatMap(callback -> callback.forMessage((MessageRepresentation)messageRepresentation, mailboxId, owner)).then();
    }

    private Mono<Void> deleteBodyBlob(PostgresMessageId id, PostgresMessageDAO postgresMessageDAO) {
        return postgresMessageDAO.getBodyBlobId(id).flatMap(blobId -> Mono.from((Publisher)this.blobStore.delete(this.blobStore.getDefaultBucketName(), blobId)).then());
    }

    private Mono<Boolean> isUnreferenced(PostgresMessageId id, PostgresMailboxMessageDAO postgresMailboxMessageDAO) {
        return postgresMailboxMessageDAO.existsByMessageId(id).map(FunctionalUtils.negate());
    }

    private Mono<Void> deleteAttachment(PostgresMessageId messageId, PostgresAttachmentDAO attachmentDAO) {
        return this.deleteAttachmentBlobs(messageId, attachmentDAO).then(attachmentDAO.deleteByMessageId(messageId));
    }

    private Mono<Void> deleteAttachmentBlobs(PostgresMessageId messageId, PostgresAttachmentDAO attachmentDAO) {
        return attachmentDAO.listBlobsByMessageId(messageId).flatMap(blobId -> Mono.from((Publisher)this.blobStore.delete(this.blobStore.getDefaultBucketName(), blobId)), 16).then();
    }

    public static class DeleteMessageListenerGroup
    extends Group {
    }

    @FunctionalInterface
    public static interface DeletionCallback {
        public Mono<Void> forMessage(MessageRepresentation var1, MailboxId var2, Username var3);
    }
}

