/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.protocol.internal.request.query;

import com.datastax.dse.protocol.internal.request.query.ContinuousPagingOptions;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.util.Flags;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

public class DseQueryOptions
extends QueryOptions {
    public final boolean isPageSizeInBytes;
    public final ContinuousPagingOptions continuousPagingOptions;

    public DseQueryOptions(int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        this(DseQueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions), consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace, isPageSizeInBytes, continuousPagingOptions);
    }

    protected static int computeFlags(List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        int flags = QueryOptions.computeFlags(positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace, Integer.MIN_VALUE);
        if (isPageSizeInBytes) {
            flags = Flags.add(flags, 0x40000000);
        }
        if (continuousPagingOptions != null) {
            flags = Flags.add(flags, Integer.MIN_VALUE);
        }
        return flags;
    }

    public DseQueryOptions(int flags, int consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, int serialConsistency, long defaultTimestamp, String keyspace, boolean isPageSizeInBytes, ContinuousPagingOptions continuousPagingOptions) {
        super(flags, consistency, positionalValues, namedValues, skipMetadata, pageSize, pagingState, serialConsistency, defaultTimestamp, keyspace, Integer.MIN_VALUE);
        this.isPageSizeInBytes = isPageSizeInBytes;
        this.continuousPagingOptions = continuousPagingOptions;
    }
}

