/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HistogramBucket
extends MultiBucketBase {
    @Nullable
    private final String keyAsString;
    private final double key;
    public static final JsonpDeserializer<HistogramBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramBucket::setupHistogramBucketDeserializer);

    private HistogramBucket(Builder builder) {
        super(builder);
        this.keyAsString = builder.keyAsString;
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static HistogramBucket of(Function<Builder, ObjectBuilder<HistogramBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    public final double key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
        generator.writeKey("key");
        generator.write(this.key);
    }

    protected static void setupHistogramBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
        op.add(Builder::key, JsonpDeserializer.doubleDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramBucket> {
        @Nullable
        private String keyAsString;
        private Double key;

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        public final Builder key(double value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramBucket build() {
            this._checkSingleUse();
            return new HistogramBucket(this);
        }
    }
}

