/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.UnassignedInformationReason;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class UnassignedInformation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, UnassignedInformation> {
    @Nullable
    private final String allocationStatus;
    @Nonnull
    private final String at;
    @Nullable
    private final Boolean delayed;
    @Nullable
    private final String details;
    @Nullable
    private final Integer failedAllocationAttempts;
    @Nullable
    private final String lastAllocationStatus;
    @Nonnull
    private final UnassignedInformationReason reason;
    public static final JsonpDeserializer<UnassignedInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UnassignedInformation::setupUnassignedInformationDeserializer);

    private UnassignedInformation(Builder builder) {
        this.allocationStatus = builder.allocationStatus;
        this.at = ApiTypeHelper.requireNonNull(builder.at, this, "at");
        this.delayed = builder.delayed;
        this.details = builder.details;
        this.failedAllocationAttempts = builder.failedAllocationAttempts;
        this.lastAllocationStatus = builder.lastAllocationStatus;
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
    }

    public static UnassignedInformation of(Function<Builder, ObjectBuilder<UnassignedInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String allocationStatus() {
        return this.allocationStatus;
    }

    @Nonnull
    public final String at() {
        return this.at;
    }

    @Nullable
    public final Boolean delayed() {
        return this.delayed;
    }

    @Nullable
    public final String details() {
        return this.details;
    }

    @Nullable
    public final Integer failedAllocationAttempts() {
        return this.failedAllocationAttempts;
    }

    @Nullable
    public final String lastAllocationStatus() {
        return this.lastAllocationStatus;
    }

    @Nonnull
    public final UnassignedInformationReason reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocationStatus != null) {
            generator.writeKey("allocation_status");
            generator.write(this.allocationStatus);
        }
        generator.writeKey("at");
        generator.write(this.at);
        if (this.delayed != null) {
            generator.writeKey("delayed");
            generator.write(this.delayed.booleanValue());
        }
        if (this.details != null) {
            generator.writeKey("details");
            generator.write(this.details);
        }
        if (this.failedAllocationAttempts != null) {
            generator.writeKey("failed_allocation_attempts");
            generator.write(this.failedAllocationAttempts.intValue());
        }
        if (this.lastAllocationStatus != null) {
            generator.writeKey("last_allocation_status");
            generator.write(this.lastAllocationStatus);
        }
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUnassignedInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocationStatus, JsonpDeserializer.stringDeserializer(), "allocation_status");
        op.add(Builder::at, JsonpDeserializer.stringDeserializer(), "at");
        op.add(Builder::delayed, JsonpDeserializer.booleanDeserializer(), "delayed");
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details");
        op.add(Builder::failedAllocationAttempts, JsonpDeserializer.integerDeserializer(), "failed_allocation_attempts");
        op.add(Builder::lastAllocationStatus, JsonpDeserializer.stringDeserializer(), "last_allocation_status");
        op.add(Builder::reason, UnassignedInformationReason._DESERIALIZER, "reason");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allocationStatus);
        result = 31 * result + this.at.hashCode();
        result = 31 * result + Objects.hashCode(this.delayed);
        result = 31 * result + Objects.hashCode(this.details);
        result = 31 * result + Objects.hashCode(this.failedAllocationAttempts);
        result = 31 * result + Objects.hashCode(this.lastAllocationStatus);
        result = 31 * result + this.reason.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnassignedInformation other = (UnassignedInformation)o;
        return Objects.equals(this.allocationStatus, other.allocationStatus) && this.at.equals(other.at) && Objects.equals(this.delayed, other.delayed) && Objects.equals(this.details, other.details) && Objects.equals(this.failedAllocationAttempts, other.failedAllocationAttempts) && Objects.equals(this.lastAllocationStatus, other.lastAllocationStatus) && this.reason.equals(other.reason);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, UnassignedInformation> {
        @Nullable
        private String allocationStatus;
        private String at;
        @Nullable
        private Boolean delayed;
        @Nullable
        private String details;
        @Nullable
        private Integer failedAllocationAttempts;
        @Nullable
        private String lastAllocationStatus;
        private UnassignedInformationReason reason;

        public Builder() {
        }

        private Builder(UnassignedInformation o) {
            this.allocationStatus = o.allocationStatus;
            this.at = o.at;
            this.delayed = o.delayed;
            this.details = o.details;
            this.failedAllocationAttempts = o.failedAllocationAttempts;
            this.lastAllocationStatus = o.lastAllocationStatus;
            this.reason = o.reason;
        }

        private Builder(Builder o) {
            this.allocationStatus = o.allocationStatus;
            this.at = o.at;
            this.delayed = o.delayed;
            this.details = o.details;
            this.failedAllocationAttempts = o.failedAllocationAttempts;
            this.lastAllocationStatus = o.lastAllocationStatus;
            this.reason = o.reason;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allocationStatus(@Nullable String value) {
            this.allocationStatus = value;
            return this;
        }

        @Nonnull
        public final Builder at(String value) {
            this.at = value;
            return this;
        }

        @Nonnull
        public final Builder delayed(@Nullable Boolean value) {
            this.delayed = value;
            return this;
        }

        @Nonnull
        public final Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        @Nonnull
        public final Builder failedAllocationAttempts(@Nullable Integer value) {
            this.failedAllocationAttempts = value;
            return this;
        }

        @Nonnull
        public final Builder lastAllocationStatus(@Nullable String value) {
            this.lastAllocationStatus = value;
            return this;
        }

        @Nonnull
        public final Builder reason(UnassignedInformationReason value) {
            this.reason = value;
            return this;
        }

        @Override
        @Nonnull
        public UnassignedInformation build() {
            this._checkSingleUse();
            return new UnassignedInformation(this);
        }
    }
}

