/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.field_caps;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FieldCapability
implements PlainJsonSerializable {
    private final boolean aggregatable;
    private final List<String> indices;
    private final Map<String, List<String>> meta;
    private final List<String> nonAggregatableIndices;
    private final List<String> nonSearchableIndices;
    private final boolean searchable;
    private final String type;
    @Nullable
    private final Boolean metadataField;
    public static final JsonpDeserializer<FieldCapability> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCapability::setupFieldCapabilityDeserializer);

    private FieldCapability(Builder builder) {
        this.aggregatable = ApiTypeHelper.requireNonNull(builder.aggregatable, this, "aggregatable");
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.nonAggregatableIndices = ApiTypeHelper.unmodifiable(builder.nonAggregatableIndices);
        this.nonSearchableIndices = ApiTypeHelper.unmodifiable(builder.nonSearchableIndices);
        this.searchable = ApiTypeHelper.requireNonNull(builder.searchable, this, "searchable");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.metadataField = builder.metadataField;
    }

    public static FieldCapability of(Function<Builder, ObjectBuilder<FieldCapability>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean aggregatable() {
        return this.aggregatable;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final Map<String, List<String>> meta() {
        return this.meta;
    }

    public final List<String> nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public final List<String> nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public final boolean searchable() {
        return this.searchable;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean metadataField() {
        return this.metadataField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aggregatable");
        generator.write(this.aggregatable);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nonAggregatableIndices)) {
            generator.writeKey("non_aggregatable_indices");
            generator.writeStartArray();
            for (String string : this.nonAggregatableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nonSearchableIndices)) {
            generator.writeKey("non_searchable_indices");
            generator.writeStartArray();
            for (String string : this.nonSearchableIndices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("searchable");
        generator.write(this.searchable);
        generator.writeKey("type");
        generator.write(this.type);
        if (this.metadataField != null) {
            generator.writeKey("metadata_field");
            generator.write(this.metadataField.booleanValue());
        }
    }

    protected static void setupFieldCapabilityDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregatable, JsonpDeserializer.booleanDeserializer(), "aggregatable");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "meta");
        op.add(Builder::nonAggregatableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_aggregatable_indices");
        op.add(Builder::nonSearchableIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "non_searchable_indices");
        op.add(Builder::searchable, JsonpDeserializer.booleanDeserializer(), "searchable");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::metadataField, JsonpDeserializer.booleanDeserializer(), "metadata_field");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldCapability> {
        private Boolean aggregatable;
        @Nullable
        private List<String> indices;
        @Nullable
        private Map<String, List<String>> meta;
        @Nullable
        private List<String> nonAggregatableIndices;
        @Nullable
        private List<String> nonSearchableIndices;
        private Boolean searchable;
        private String type;
        @Nullable
        private Boolean metadataField;

        public final Builder aggregatable(boolean value) {
            this.aggregatable = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder meta(Map<String, List<String>> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, List<String> value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder nonAggregatableIndices(List<String> list) {
            this.nonAggregatableIndices = Builder._listAddAll(this.nonAggregatableIndices, list);
            return this;
        }

        public final Builder nonAggregatableIndices(String value, String ... values) {
            this.nonAggregatableIndices = Builder._listAdd(this.nonAggregatableIndices, value, values);
            return this;
        }

        public final Builder nonSearchableIndices(List<String> list) {
            this.nonSearchableIndices = Builder._listAddAll(this.nonSearchableIndices, list);
            return this;
        }

        public final Builder nonSearchableIndices(String value, String ... values) {
            this.nonSearchableIndices = Builder._listAdd(this.nonSearchableIndices, value, values);
            return this;
        }

        public final Builder searchable(boolean value) {
            this.searchable = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder metadataField(@Nullable Boolean value) {
            this.metadataField = value;
            return this;
        }

        @Override
        public FieldCapability build() {
            this._checkSingleUse();
            return new FieldCapability(this);
        }
    }
}

