/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.lmtpserver;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.api.MailProcessor;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.lmtp.LMTPMultiResponse;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.smtpserver.DataLineJamesMessageHookHandler;
import org.apache.mailet.Mail;

public class MailetContainerHandler
extends DataLineJamesMessageHookHandler {
    private final MailProcessor mailProcessor;
    private Configuration configuration;

    @Inject
    public MailetContainerHandler(MailProcessor mailProcessor) {
        this.mailProcessor = mailProcessor;
        this.configuration = Configuration.DEFAULT;
    }

    public void init(org.apache.commons.configuration2.Configuration config) throws ConfigurationException {
        this.configuration = Configuration.parse(config);
    }

    protected Response processExtensions(SMTPSession session, Mail mail, MimeMessageInputStreamSource mmiss) {
        ImmutableList recipients = ImmutableList.copyOf((Collection)mail.getRecipients());
        this.executeJamesMessageHooks(session, mail);
        if (recipients.isEmpty()) {
            AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("503").smtpDescription(DSNStatus.getStatus((int)5, (String)"6.0") + " No recipients").build());
        }
        if (this.configuration.splitExecutionEnabled()) {
            return this.executeEachRecipientSeparately(mail, (Collection<MailAddress>)recipients);
        }
        return this.executeAllRecipientsAtOnce(mail, (Collection<MailAddress>)recipients);
    }

    private LMTPMultiResponse executeAllRecipientsAtOnce(Mail mail, Collection<MailAddress> recipients) {
        try {
            this.mailProcessor.service(mail);
            return LMTPMultiResponse.of((List)((List)recipients.stream().map(recipient -> AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received <" + recipient.asString() + ">").build())).collect(ImmutableList.toImmutableList())));
        }
        catch (Exception e) {
            return LMTPMultiResponse.of((List)((List)recipients.stream().map(recipient -> new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Temporary error deliver message <" + recipient.asString() + ">"))).collect(ImmutableList.toImmutableList())));
        }
    }

    private LMTPMultiResponse executeEachRecipientSeparately(Mail mail, Collection<MailAddress> recipients) {
        return LMTPMultiResponse.of((List)((List)recipients.stream().map(recipient -> this.executeFor(mail, (MailAddress)recipient)).collect(ImmutableList.toImmutableList())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMTPResponse executeFor(Mail mail, MailAddress recipient) {
        Mail newMail = null;
        try {
            newMail = mail.duplicate();
            newMail.setRecipients((Collection)ImmutableList.of((Object)recipient));
            this.mailProcessor.service(newMail);
            SMTPResponse sMTPResponse = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpReturnCode("250").smtpDescription(DSNStatus.getStatus((int)2, (String)"6.0") + " Message received <" + recipient.asString() + ">").build());
            return sMTPResponse;
        }
        catch (Exception e) {
            SMTPResponse sMTPResponse = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Temporary error deliver message <" + recipient.asString() + ">"));
            return sMTPResponse;
        }
        finally {
            LifecycleUtil.dispose((Object)newMail);
        }
    }

    private static class Configuration {
        static Configuration DEFAULT = new Configuration(false);
        private final boolean splitExecution;

        static Configuration parse(org.apache.commons.configuration2.Configuration config) {
            return new Configuration(config.getBoolean("splitExecution", false));
        }

        private Configuration(boolean splitExecution) {
            this.splitExecution = splitExecution;
        }

        public boolean splitExecutionEnabled() {
            return this.splitExecution;
        }

        public final boolean equals(Object o) {
            if (o instanceof Configuration) {
                Configuration other = (Configuration)o;
                return Objects.equals(this.splitExecution, other.splitExecution);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.splitExecution);
        }
    }
}

