/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public abstract class AbstCombFactory
extends AbstRandomBasedFactory {
    protected Supplier<Instant> instantFunction;

    protected AbstCombFactory(UuidVersion version, Builder<?, ?> builder) {
        super(version, builder);
        this.instantFunction = builder.getInstantFunction();
    }

    public static abstract class Builder<T, B extends Builder<T, B>>
    extends AbstRandomBasedFactory.Builder<T, B> {
        protected Supplier<Instant> instantFunction;

        protected Supplier<Instant> getInstantFunction() {
            if (this.instantFunction == null) {
                this.instantFunction = () -> Instant.now();
            }
            return this.instantFunction;
        }

        public B withClock(Clock clock) {
            if (clock != null) {
                this.instantFunction = () -> clock.instant();
            }
            return (B)this;
        }

        public B withTimeFunction(LongSupplier timeFunction) {
            this.instantFunction = () -> Instant.ofEpochMilli(timeFunction.getAsLong());
            return (B)this;
        }

        public B withInstantFunction(Supplier<Instant> instantFunction) {
            this.instantFunction = instantFunction;
            return (B)this;
        }
    }
}

