/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.jmap.api.filtering.FilteringManagement;
import org.apache.james.jmap.api.filtering.FiltersDeleteUserDataTaskStep;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.filtering.impl.FilterUsernameChangeTaskStep;
import org.apache.james.jmap.api.identity.CustomIdentityDAO;
import org.apache.james.jmap.api.identity.IdentityUserDeletionTaskStep;
import org.apache.james.jmap.api.projections.EmailQueryView;
import org.apache.james.jmap.api.projections.EmailQueryViewManager;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.api.projections.MessageFastViewProjectionHealthCheck;
import org.apache.james.jmap.api.pushsubscription.PushDeleteUserDataTaskStep;
import org.apache.james.jmap.api.upload.UploadRepository;
import org.apache.james.jmap.postgres.filtering.PostgresFilteringProjection;
import org.apache.james.jmap.postgres.identity.PostgresCustomIdentityDAO;
import org.apache.james.jmap.postgres.projections.PostgresEmailQueryView;
import org.apache.james.jmap.postgres.projections.PostgresEmailQueryViewManager;
import org.apache.james.jmap.postgres.projections.PostgresMessageFastViewProjection;
import org.apache.james.jmap.postgres.projections.PostgresMessageFastViewProjectionDeletionCallback;
import org.apache.james.jmap.postgres.upload.PostgresUploadRepository;
import org.apache.james.mailbox.postgres.DeleteMessageListener;
import org.apache.james.mailbox.store.extractor.DefaultTextExtractor;
import org.apache.james.user.api.DeleteUserDataTaskStep;
import org.apache.james.user.api.UsernameChangeTaskStep;

public class PostgresDataJmapModule
extends AbstractModule {
    protected void configure() {
        this.bind(UploadRepository.class).to(PostgresUploadRepository.class);
        this.bind(PostgresCustomIdentityDAO.class).in(Scopes.SINGLETON);
        this.bind(CustomIdentityDAO.class).to(PostgresCustomIdentityDAO.class);
        this.bind(EventSourcingFilteringManagement.class).in(Scopes.SINGLETON);
        this.bind(FilteringManagement.class).to(EventSourcingFilteringManagement.class).asEagerSingleton();
        this.bind(PostgresFilteringProjection.class).in(Scopes.SINGLETON);
        this.bind(EventSourcingFilteringManagement.ReadProjection.class).to(PostgresFilteringProjection.class);
        this.bind(DefaultTextExtractor.class).in(Scopes.SINGLETON);
        this.bind(PostgresMessageFastViewProjection.class).in(Scopes.SINGLETON);
        this.bind(MessageFastViewProjection.class).to(PostgresMessageFastViewProjection.class);
        Multibinder.newSetBinder((Binder)this.binder(), DeleteMessageListener.DeletionCallback.class).addBinding().to(PostgresMessageFastViewProjectionDeletionCallback.class);
        this.bind(PostgresEmailQueryView.class).in(Scopes.SINGLETON);
        this.bind(EmailQueryView.class).to(PostgresEmailQueryView.class);
        this.bind(PostgresEmailQueryView.class).in(Scopes.SINGLETON);
        this.bind(EmailQueryViewManager.class).to(PostgresEmailQueryViewManager.class);
        this.bind(MessageFastViewProjectionHealthCheck.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class).addBinding().to(MessageFastViewProjectionHealthCheck.class);
        Multibinder.newSetBinder((Binder)this.binder(), UsernameChangeTaskStep.class).addBinding().to(FilterUsernameChangeTaskStep.class);
        Multibinder deleteUserDataTaskSteps = Multibinder.newSetBinder((Binder)this.binder(), DeleteUserDataTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(FiltersDeleteUserDataTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(IdentityUserDeletionTaskStep.class);
        deleteUserDataTaskSteps.addBinding().to(PushDeleteUserDataTaskStep.class);
    }
}

