/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.relation;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.relation.MultiColumnRelationBuilder;
import com.datastax.oss.driver.api.querybuilder.relation.OngoingWhereClause;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.lhs.TupleLeftOperand;
import com.datastax.oss.driver.internal.querybuilder.relation.DefaultRelation;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultMultiColumnRelationBuilder
implements MultiColumnRelationBuilder<Relation> {
    private final Iterable<CqlIdentifier> identifiers;

    public DefaultMultiColumnRelationBuilder(@NonNull Iterable<CqlIdentifier> identifiers) {
        Preconditions.checkNotNull(identifiers);
        Preconditions.checkArgument((boolean)identifiers.iterator().hasNext(), (Object)"Tuple must contain at least one column");
        this.identifiers = identifiers;
    }

    @Override
    @NonNull
    public Relation build(@NonNull String operator, @Nullable Term rightOperand) {
        return new DefaultRelation(new TupleLeftOperand(this.identifiers), operator, rightOperand);
    }

    @Immutable
    public static class Fluent<StatementT extends OngoingWhereClause<StatementT>>
    implements MultiColumnRelationBuilder<StatementT> {
        private final OngoingWhereClause<StatementT> statement;
        private final MultiColumnRelationBuilder<Relation> delegate;

        public Fluent(@NonNull OngoingWhereClause<StatementT> statement, @NonNull Iterable<CqlIdentifier> identifiers) {
            this.statement = statement;
            this.delegate = new DefaultMultiColumnRelationBuilder(identifiers);
        }

        @Override
        @NonNull
        public StatementT build(@NonNull String operator, @Nullable Term rightOperand) {
            return this.statement.where((Relation)this.delegate.build(operator, rightOperand));
        }
    }
}

