/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class AliasReverseResolverImpl
implements AliasReverseResolver {
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    public AliasReverseResolverImpl(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public Flux<MailAddress> listAddresses(Username user) {
        CanSendFromImpl.DomainFetcher domains = this.domainFetcher();
        return this.relatedAliases(user).flatMap(allowedUser -> (Publisher)user.getDomainPart().map(domain -> {
            Publisher[] publisherArray = new Publisher[2];
            publisherArray[0] = Flux.just((Object)allowedUser);
            publisherArray[1] = domains.fetch((Domain)domain).map(arg_0 -> ((Username)allowedUser).withOtherDomain(arg_0));
            return Flux.concat((Publisher[])publisherArray);
        }).orElseGet(() -> Flux.just((Object)allowedUser))).map(Throwing.function(Username::asMailAddress).sneakyThrow()).distinct();
    }

    private Flux<Username> relatedAliases(Username user) {
        Pair userWithDepth = Pair.of((Object)user, (Object)0);
        return Flux.just((Object)userWithDepth).expand(value -> {
            if ((long)((Integer)value.getRight()).intValue() >= this.getMappingLimit()) {
                return Flux.empty();
            }
            return this.recipientRewriteTable.listSourcesReactive(Mapping.alias((String)((Username)value.getLeft()).asString())).map(MappingSource::asUsername).handle(ReactorUtils.publishIfPresent()).map(u -> Pair.of((Object)u, (Object)((Integer)value.getRight() + 1)));
        }).map(Pair::getLeft);
    }

    private CanSendFromImpl.DomainFetcher domainFetcher() {
        return new CanSendFromImpl.DomainFetcher(){
            private final Map<Domain, List<Domain>> memoized = new ConcurrentHashMap<Domain, List<Domain>>();

            @Override
            public Flux<Domain> fetch(Domain domain) {
                if (this.memoized.containsKey(domain)) {
                    return Flux.fromIterable((Iterable)this.memoized.get(domain));
                }
                return AliasReverseResolverImpl.this.fetchDomains(domain).collect(Collectors.toList()).doOnNext(next -> this.memoized.put(domain, (List<Domain>)next)).flatMapIterable(i -> i);
            }
        };
    }

    private Flux<Domain> fetchDomains(Domain domain) {
        Pair domainWithDepth = Pair.of((Object)domain, (Object)0);
        Flux flux = Flux.just((Object)domainWithDepth);
        return this.expandDomains((Flux<Pair<Domain, Integer>>)flux);
    }

    private Flux<Domain> expandDomains(Flux<Pair<Domain, Integer>> flux) {
        return flux.expand(value -> {
            Preconditions.checkArgument(((long)((Integer)value.getRight()).intValue() < this.getMappingLimit() ? 1 : 0) != 0);
            return this.recipientRewriteTable.listSourcesReactive(Mapping.domainAlias((Domain)((Domain)value.getKey()))).map(MappingSource::asDomain).handle(ReactorUtils.publishIfPresent()).map(u -> Pair.of((Object)u, (Object)((Integer)value.getRight() + 1)));
        }).map(Pair::getLeft);
    }

    private long getMappingLimit() {
        return this.recipientRewriteTable.getConfiguration().getMappingLimit();
    }
}

