/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.commands;

import java.util.List;
import org.apache.jsieve.Argument;
import org.apache.jsieve.Arguments;
import org.apache.jsieve.Block;
import org.apache.jsieve.Constants;
import org.apache.jsieve.SieveContext;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.commands.AbstractPrologCommand;
import org.apache.jsieve.exception.FeatureException;
import org.apache.jsieve.exception.LookupException;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;

public class Require
extends AbstractPrologCommand {
    @Override
    protected Object executeBasic(MailAdapter mail, Arguments arguments, Block block, SieveContext context) throws SieveException {
        List<String> stringArgumentList = ((StringListArgument)arguments.getArgumentList().get(0)).getList();
        for (String stringArgument : stringArgumentList) {
            this.validateFeature(stringArgument, mail, context);
        }
        return null;
    }

    protected void validateFeature(String name, MailAdapter mail, SieveContext context) throws FeatureException {
        if (name.startsWith("comparator-")) {
            String comparatorName = name.substring(Constants.COMPARATOR_PREFIX_LENGTH);
            if (!context.getComparatorManager().isSupported(comparatorName)) {
                throw new FeatureException("Comparator \"" + comparatorName + "\" is not supported.");
            }
        } else {
            try {
                this.validateCommand(name, context);
                return;
            }
            catch (LookupException comparatorName) {
                try {
                    this.validateTest(name, context);
                }
                catch (LookupException e) {
                    throw new FeatureException("Feature \"" + name + "\" is not supported.");
                }
            }
        }
    }

    protected void validateCommand(String name, SieveContext context) throws LookupException {
        context.getCommandManager().getCommand(name);
    }

    protected void validateTest(String name, SieveContext context) throws LookupException {
        context.getTestManager().getTest(name);
    }

    @Override
    protected void validateArguments(Arguments arguments, SieveContext context) throws SieveException {
        List<Argument> args = arguments.getArgumentList();
        if (args.size() != 1) {
            throw context.getCoordinate().syntaxException("Exactly 1 argument permitted. Found " + args.size());
        }
        Argument argument = args.get(0);
        if (!(argument instanceof StringListArgument)) {
            throw context.getCoordinate().syntaxException("Expecting a string-list");
        }
    }
}

