/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.Address;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.MailAddress;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.field.address.LenientAddressParser;
import org.apache.james.transport.mailets.VacationReply;
import org.apache.james.transport.util.MimeMessageBodyGenerator;
import org.apache.james.util.StreamUtils;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.vacation.api.AccountId;
import org.apache.james.vacation.api.RecipientId;
import org.apache.james.vacation.api.Vacation;
import org.apache.james.vacation.api.VacationService;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetConfig;
import org.apache.mailet.base.AutomaticallySentMailDetector;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.MailetUtil;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class VacationMailet
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(VacationMailet.class);
    private final VacationService vacationService;
    private final ZonedDateTimeProvider zonedDateTimeProvider;
    private final AutomaticallySentMailDetector automaticallySentMailDetector;
    private final MimeMessageBodyGenerator mimeMessageBodyGenerator;
    private boolean useUserAsMailFrom = false;

    @Inject
    public VacationMailet(VacationService vacationService, ZonedDateTimeProvider zonedDateTimeProvider, AutomaticallySentMailDetector automaticallySentMailDetector, MimeMessageBodyGenerator mimeMessageBodyGenerator) {
        this.vacationService = vacationService;
        this.zonedDateTimeProvider = zonedDateTimeProvider;
        this.automaticallySentMailDetector = automaticallySentMailDetector;
        this.mimeMessageBodyGenerator = mimeMessageBodyGenerator;
    }

    public void service(Mail mail) {
        try {
            if (!mail.hasSender()) {
                return;
            }
            boolean hasReplyToHeaderField = Optional.ofNullable(VacationMailet.getReplyTo(mail)).map(replyToFields -> ((Address[])replyToFields).length > 0).orElse(false);
            if (!this.automaticallySentMailDetector.isAutomaticallySent(mail) && hasReplyToHeaderField && !this.isNoReplySender(mail)) {
                ZonedDateTime processingDate = (ZonedDateTime)this.zonedDateTimeProvider.get();
                mail.getRecipients().forEach(mailAddress -> this.manageVacation((MailAddress)mailAddress, mail, processingDate));
            }
        }
        catch (AddressException e) {
            if (!e.getMessage().equals("Empty address")) {
                LOGGER.warn("Can not process vacation for one or more recipients in {}", (Object)mail.getRecipients(), (Object)e);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can not process vacation for one or more recipients in {}", (Object)mail.getRecipients(), (Object)e);
        }
    }

    public void init() throws MessagingException {
        this.useUserAsMailFrom = MailetUtil.getInitParameter((MailetConfig)this.getMailetConfig(), (String)"useUserAsMailFrom").orElse(false);
    }

    private static Address[] getReplyTo(Mail mail) throws MessagingException {
        try {
            return mail.getMessage().getReplyTo();
        }
        catch (AddressException e) {
            Object[] replyTo = (InternetAddress[])StreamUtils.ofNullable((Object[])mail.getMessage().getHeader("Reply-To")).map(arg_0 -> ((LenientAddressParser)LenientAddressParser.DEFAULT).parseAddressList(arg_0)).flatMap(Collection::stream).filter(Mailbox.class::isInstance).map(Mailbox.class::cast).map(Mailbox::getAddress).map(Throwing.function(InternetAddress::new)).toArray(InternetAddress[]::new);
            if (replyTo.length > 0) {
                LOGGER.info("Recovering from badly formatted Reply-To. Original value {}, deduced value {}", new Object[]{ImmutableList.copyOf((Object[])mail.getMessage().getHeader("Reply-To")), ImmutableList.copyOf((Object[])replyTo), e});
                mail.getMessage().setReplyTo((Address[])replyTo);
                return replyTo;
            }
            throw e;
        }
    }

    private void manageVacation(MailAddress recipient, Mail processedMail, ZonedDateTime processingDate) {
        if (this.isSentToSelf(processedMail.getMaybeSender().asOptional(), recipient)) {
            return;
        }
        AccountId accountId = AccountId.fromString((String)recipient.toString());
        Mono vacation = this.vacationService.retrieveVacation(accountId);
        Mono alreadySent = this.vacationService.isNotificationRegistered(AccountId.fromString((String)recipient.toString()), RecipientId.fromMailAddress((MailAddress)processedMail.getMaybeSender().get()));
        Pair pair = (Pair)Flux.combineLatest((Publisher)vacation, (Publisher)alreadySent, Pair::of).blockFirst();
        this.sendNotificationIfRequired(recipient, processedMail, processingDate, (Vacation)pair.getKey(), (Boolean)pair.getValue());
    }

    private void sendNotificationIfRequired(MailAddress recipient, Mail processedMail, ZonedDateTime processingDate, Vacation vacation, Boolean alreadySent) {
        if (this.shouldSendNotification(vacation, processingDate, alreadySent)) {
            this.sendNotification(recipient, processedMail, vacation);
        }
    }

    private boolean shouldSendNotification(Vacation vacation, ZonedDateTime processingDate, boolean alreadySent) {
        return vacation.isActiveAtDate(processingDate) && !alreadySent;
    }

    private boolean isNoReplySender(Mail processedMail) {
        return processedMail.getMaybeSender().asOptional().map(address -> address.getLocalPart().toLowerCase(Locale.US).endsWith("-noreply")).orElse(true);
    }

    private boolean isSentToSelf(Optional<MailAddress> maybeSender, MailAddress recipient) {
        return maybeSender.map(sender -> sender.equals((Object)recipient)).orElse(false);
    }

    private void sendNotification(MailAddress recipient, Mail processedMail, Vacation vacation) {
        try {
            VacationReply vacationReply = VacationReply.builder(processedMail).receivedMailRecipient(recipient).vacation(vacation).build(this.mimeMessageBodyGenerator);
            this.sendNotification(vacationReply, recipient);
            this.vacationService.registerNotification(AccountId.fromString((String)recipient.toString()), RecipientId.fromMailAddress((MailAddress)processedMail.getMaybeSender().get()), vacation.getToDate()).block();
        }
        catch (MessagingException e) {
            LOGGER.warn("Failed to send JMAP vacation notification from {} to {}", new Object[]{recipient, processedMail.getMaybeSender(), e});
        }
    }

    private void sendNotification(VacationReply vacationReply, MailAddress recipient) throws MessagingException {
        this.getMailetContext().sendMail(this.getSender(recipient), vacationReply.getRecipients(), vacationReply.getMimeMessage());
    }

    private MailAddress getSender(MailAddress recipient) {
        if (!this.useUserAsMailFrom) {
            return MailAddress.nullSender();
        }
        return recipient;
    }
}

