/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import io.netty.channel.ChannelHandlerContext;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieveserver.netty.NettyConstants;
import org.apache.james.protocols.api.ProxyInformation;
import org.apache.james.util.MDCBuilder;

public class ManageSieveMDCContext {
    public static Closeable from(ChannelHandlerContext ctx) {
        MDCBuilder builder = MDCBuilder.create().addToContext(ManageSieveMDCContext.from((Session)ctx.channel().attr(NettyConstants.SESSION_ATTRIBUTE_KEY).get())).addToContext("protocol", "MANAGE-SIEVE").addToContext("sessionId", ctx.channel().id().asShortText());
        ManageSieveMDCContext.addRemoteInformation(ctx, builder);
        return builder.build();
    }

    private static void addRemoteInformation(ChannelHandlerContext ctx, MDCBuilder builder) {
        Optional<ProxyInformation> proxyInformation = Optional.ofNullable((ProxyInformation)ctx.channel().attr(NettyConstants.PROXY_INFO).get());
        if (proxyInformation.isPresent()) {
            builder.addToContext("ip", proxyInformation.get().getSource().getAddress().getHostAddress());
            builder.addToContext("host", proxyInformation.get().getSource().getHostName());
        } else {
            builder.addToContext("ip", ManageSieveMDCContext.retrieveIp(ctx));
            builder.addToContext("host", ManageSieveMDCContext.retrieveHost(ctx));
        }
    }

    private static String retrieveIp(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getAddress().getHostAddress();
        }
        return remoteAddress.toString();
    }

    private static String retrieveHost(ChannelHandlerContext ctx) {
        SocketAddress remoteAddress = ctx.channel().remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)remoteAddress;
            return address.getHostName();
        }
        return remoteAddress.toString();
    }

    private static MDCBuilder from(Session session) {
        return Optional.ofNullable(session).map(s -> MDCBuilder.create().addToContextIfPresent("user", Optional.ofNullable(s.getUser()).map(Username::asString))).orElse(MDCBuilder.create());
    }
}

