/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.AutoloadedDriver;
import org.apache.derby.iapi.jdbc.EmbeddedDataSourceInterface;
import org.apache.derby.iapi.jdbc.EmbeddedXADataSourceInterface;
import org.apache.derby.iapi.jdbc.InternalDriver;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.apache.derby.shared.common.i18n.MessageService;

public class BasicEmbeddedDataSource40
implements DataSource,
Serializable,
EmbeddedDataSourceInterface {
    private static final long serialVersionUID = -4945135214995641182L;
    protected String description;
    protected String dataSourceName;
    protected String databaseName;
    protected String connectionAttributes;
    protected String createDatabase;
    protected String shutdownDatabase;
    protected boolean attributesAsPassword;
    private String shortDatabaseName;
    private String password;
    private String user;
    protected int loginTimeout;
    private transient PrintWriter printer;
    protected transient String jdbcurl;
    protected transient InternalDriver driver;

    public BasicEmbeddedDataSource40() {
        this.update();
    }

    public synchronized void setDatabaseName(String string) {
        this.databaseName = string;
        if (string != null && string.contains(";")) {
            String[] stringArray = string.split(";");
            this.shortDatabaseName = stringArray[0];
        } else {
            this.shortDatabaseName = string;
        }
        this.update();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    private String getShortDatabaseName() {
        return this.shortDatabaseName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.printer = printWriter;
    }

    protected void update() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("jdbc:derby:");
        String string = this.getDatabaseName();
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() == 0) {
            string = " ";
        }
        stringBuilder.append(string);
        String string2 = this.getConnectionAttributes();
        if (string2 != null && (string2 = string2.trim()).length() != 0) {
            stringBuilder.append(';');
            stringBuilder.append(this.connectionAttributes);
        }
        this.jdbcurl = stringBuilder.toString();
    }

    public void setCreateDatabase(String string) {
        this.createDatabase = string != null && string.toLowerCase(Locale.ENGLISH).equals("create") ? string : null;
    }

    public String getCreateDatabase() {
        return this.createDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InternalDriver findDriver() throws SQLException {
        String string = this.jdbcurl;
        BasicEmbeddedDataSource40 basicEmbeddedDataSource40 = this;
        synchronized (basicEmbeddedDataSource40) {
            if (this.driver == null || !this.driver.acceptsURL(string)) {
                new EmbeddedDriver();
                Driver driver = DriverManager.getDriver(string);
                this.driver = driver instanceof AutoloadedDriver ? (InternalDriver)AutoloadedDriver.getDriverModule() : (InternalDriver)driver;
            }
        }
        return this.driver;
    }

    public void setConnectionAttributes(String string) {
        this.connectionAttributes = string;
        this.update();
    }

    public String getConnectionAttributes() {
        return this.connectionAttributes;
    }

    public void setShutdownDatabase(String string) {
        this.shutdownDatabase = string != null && string.equalsIgnoreCase("shutdown") ? string : null;
    }

    public String getShutdownDatabase() {
        return this.shutdownDatabase;
    }

    public void setAttributesAsPassword(boolean bl) {
        this.attributesAsPassword = bl;
        this.update();
    }

    public boolean getAttributesAsPassword() {
        return this.attributesAsPassword;
    }

    public boolean equals(Object object) {
        if (object instanceof EmbeddedDataSource) {
            EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)object;
            boolean bl = true;
            if (this.databaseName != null) {
                if (!this.databaseName.equals(embeddedDataSource.databaseName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.databaseName != null) {
                bl = false;
            }
            if (this.dataSourceName != null) {
                if (!this.dataSourceName.equals(embeddedDataSource.dataSourceName)) {
                    bl = false;
                }
            } else if (embeddedDataSource.dataSourceName != null) {
                bl = false;
            }
            if (this.description != null) {
                if (!this.description.equals(embeddedDataSource.description)) {
                    bl = false;
                }
            } else if (embeddedDataSource.description != null) {
                bl = false;
            }
            if (this.createDatabase != null) {
                if (!this.createDatabase.equals(embeddedDataSource.createDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.createDatabase != null) {
                bl = false;
            }
            if (this.shutdownDatabase != null) {
                if (!this.shutdownDatabase.equals(embeddedDataSource.shutdownDatabase)) {
                    bl = false;
                }
            } else if (embeddedDataSource.shutdownDatabase != null) {
                bl = false;
            }
            if (this.connectionAttributes != null) {
                if (!this.connectionAttributes.equals(embeddedDataSource.connectionAttributes)) {
                    bl = false;
                }
            } else if (embeddedDataSource.connectionAttributes != null) {
                bl = false;
            }
            if (this.loginTimeout != embeddedDataSource.loginTimeout) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = 5;
        n = 29 * n + (this.description != null ? this.description.hashCode() : 0);
        n = 29 * n + (this.dataSourceName != null ? this.dataSourceName.hashCode() : 0);
        n = 29 * n + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        n = 29 * n + (this.connectionAttributes != null ? this.connectionAttributes.hashCode() : 0);
        n = 29 * n + (this.createDatabase != null ? this.createDatabase.hashCode() : 0);
        n = 29 * n + (this.shutdownDatabase != null ? this.shutdownDatabase.hashCode() : 0);
        n = 29 * n + this.loginTimeout;
        return n;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUser(), this.getPassword(), false);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        return this.getConnection(string, string2, true);
    }

    public final Connection getConnection(String string, String string2, boolean bl) throws SQLException {
        Object object;
        Properties properties = new Properties();
        if (string != null) {
            properties.put("user", string);
        }
        if (!(bl && this.attributesAsPassword || string2 == null)) {
            properties.put("password", string2);
        }
        if (this.createDatabase != null) {
            properties.put("create", "true");
        }
        if (this.shutdownDatabase != null) {
            properties.put("shutdown", "true");
        }
        String string3 = this.jdbcurl;
        if (this.attributesAsPassword && bl && string2 != null) {
            object = new StringBuilder(string3.length() + string2.length() + 1);
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(';');
            ((StringBuilder)object).append(string2);
            string3 = ((StringBuilder)object).toString();
        }
        if ((object = this.findDriver().connect(string3, properties, this.loginTimeout)) == null) {
            throw Util.generateCsSQLException((String)"XCY00.S", (Object[])new Object[]{"databaseName", this.getDatabaseName()});
        }
        return object;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException((String)"XJ128.S", (Object[])new Object[]{clazz});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ResourceAdapter setupResourceAdapter(EmbeddedXADataSourceInterface embeddedXADataSourceInterface, ResourceAdapter resourceAdapter, String string, String string2, boolean bl) throws SQLException {
        EmbeddedXADataSourceInterface embeddedXADataSourceInterface2 = embeddedXADataSourceInterface;
        synchronized (embeddedXADataSourceInterface2) {
            if (resourceAdapter == null || !resourceAdapter.isActive()) {
                InternalDriver internalDriver;
                resourceAdapter = null;
                String string3 = ((BasicEmbeddedDataSource40)embeddedXADataSourceInterface).getShortDatabaseName();
                if (string3 != null) {
                    internalDriver = null;
                    if (BasicEmbeddedDataSource40.getMonitor() != null) {
                        internalDriver = (Database)BasicEmbeddedDataSource40.findService("org.apache.derby.database.Database", string3);
                    }
                    if (internalDriver == null) {
                        if (bl) {
                            embeddedXADataSourceInterface.getConnection(string, string2).close();
                        } else {
                            embeddedXADataSourceInterface.getConnection().close();
                        }
                        internalDriver = (Database)BasicEmbeddedDataSource40.findService("org.apache.derby.database.Database", string3);
                    }
                    if (internalDriver != null) {
                        resourceAdapter = (ResourceAdapter)internalDriver.getResourceAdapter();
                    }
                }
                if (resourceAdapter == null) {
                    throw new SQLException(MessageService.getTextMessage((String)"I024", (Object[])new Object[0]), "08006", 45000);
                }
                internalDriver = ((BasicEmbeddedDataSource40)embeddedXADataSourceInterface).findDriver();
                if (internalDriver == null) {
                    throw new SQLException(MessageService.getTextMessage((String)"I025", (Object[])new Object[0]), "08006", 45000);
                }
            }
        }
        return resourceAdapter;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw (SQLFeatureNotSupportedException)Util.generateCsSQLException((String)"0A000.S", (Object[])new Object[]{"getParentLogger"});
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object findService(String string, String string2) {
        return Monitor.findService((String)string, (String)string2);
    }
}

