/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.sslengine;

import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import nl.altindag.ssl.sslengine.DelegatingSSLEngine;
import nl.altindag.ssl.util.internal.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FenixSSLEngine
extends DelegatingSSLEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(FenixSSLEngine.class);
    private final SSLParameters sslParameters;

    public FenixSSLEngine(SSLEngine sslEngine, SSLParameters sslParameters) {
        super(sslEngine);
        this.sslParameters = sslParameters;
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        LOGGER.debug("Ignoring provided ssl parameters");
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        LOGGER.debug("Ignoring provided ciphers");
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        LOGGER.debug("Ignoring provided protocols");
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        LOGGER.debug("Ignoring provided indicator for need client auth");
    }

    @Override
    public void setWantClientAuth(boolean want) {
        LOGGER.debug("Ignoring provided indicator for want client auth");
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.updateAndGet(() -> super.getEnabledCipherSuites());
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.updateAndGet(() -> super.getEnabledProtocols());
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.updateAndGet(() -> super.getNeedClientAuth());
    }

    @Override
    public boolean getWantClientAuth() {
        return this.updateAndGet(() -> super.getWantClientAuth());
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.updateAndGet(() -> super.getSSLParameters());
    }

    private <T> T updateAndGet(Callable<T> callable) {
        this.sslEngine.setSSLParameters(this.sslParameters);
        return callable.call();
    }
}

