/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.StatusCode;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.MethodInfoUtils;
import org.apache.juneau.httppart.bean.ResponseBeanPropertyMeta;

public class ResponseBeanMeta {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    public static ResponseBeanMeta NULL = new ResponseBeanMeta(new Builder(AnnotationWorkList.create()));
    private final ClassMeta<?> cm;
    private final Map<String, ResponseBeanPropertyMeta> properties;
    private final int code;
    private final Map<String, ResponseBeanPropertyMeta> headerMethods;
    private final ResponseBeanPropertyMeta statusMethod;
    private final ResponseBeanPropertyMeta contentMethod;
    private final Optional<HttpPartSerializer> partSerializer;
    private final Optional<HttpPartParser> partParser;
    private final HttpPartSchema schema;

    public static ResponseBeanMeta create(MethodInfo m, AnnotationWorkList annotations) {
        if (!m.hasAnnotation(Response.class) && !m.getReturnType().unwrap(Value.class, Optional.class).hasAnnotation(Response.class)) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(m.getReturnType().unwrap(Value.class, Optional.class).innerType());
        AnnotationProvider ap = AP;
        CollectionUtils.rstream(ap.find(Response.class, m, new AnnotationTraversal[0])).forEach(x -> b.apply((Response)x.inner()));
        CollectionUtils.rstream(ap.find(StatusCode.class, m, new AnnotationTraversal[0])).forEach(x -> b.apply((StatusCode)x.inner()));
        return b.build();
    }

    public static ResponseBeanMeta create(ParameterInfo mpi, AnnotationWorkList annotations) {
        if (!AP.has(Response.class, mpi, new AnnotationTraversal[0])) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(mpi.getParameterType().unwrap(Value.class, Optional.class).innerType());
        CollectionUtils.rstream(AP.find(Response.class, mpi, new AnnotationTraversal[0])).forEach(x -> b.apply((Response)x.inner()));
        CollectionUtils.rstream(AP.find(StatusCode.class, mpi, new AnnotationTraversal[0])).forEach(x -> b.apply((StatusCode)x.inner()));
        return b.build();
    }

    public static ResponseBeanMeta create(Type t, AnnotationWorkList annotations) {
        ClassInfo ci = ReflectionUtils.info(t).unwrap(Value.class, Optional.class);
        if (!ci.hasAnnotation(Response.class)) {
            return null;
        }
        Builder b = new Builder(annotations);
        b.apply(ci.innerType());
        AnnotationProvider ai = AP;
        CollectionUtils.rstream(ai.find(Response.class, ci, new AnnotationTraversal[0])).forEach(x -> b.apply((Response)x.inner()));
        CollectionUtils.rstream(ai.find(StatusCode.class, ci, new AnnotationTraversal[0])).forEach(x -> b.apply((StatusCode)x.inner()));
        return b.build();
    }

    ResponseBeanMeta(Builder b) {
        this.cm = b.cm;
        this.code = b.code;
        this.partSerializer = Utils.opt(b.partSerializer).map(x -> (HttpPartSerializer)HttpPartSerializer.creator().type((Class)x).apply(b.annotations).create());
        this.partParser = Utils.opt(b.partParser).map(x -> (HttpPartParser)HttpPartParser.creator().type((Class)x).apply(b.annotations).create());
        this.schema = b.schema.build();
        LinkedHashMap<String, ResponseBeanPropertyMeta> properties = CollectionUtils.map();
        LinkedHashMap hm = CollectionUtils.map();
        b.headerMethods.forEach((k, v) -> {
            ResponseBeanPropertyMeta pm = v.build(this.partSerializer, this.partParser);
            hm.put(k, pm);
            properties.put(pm.getGetter().getName(), pm);
        });
        this.headerMethods = CollectionUtils.u(hm);
        this.contentMethod = b.contentMethod == null ? null : b.contentMethod.schema(this.schema).build(this.partSerializer, this.partParser);
        ResponseBeanPropertyMeta responseBeanPropertyMeta = this.statusMethod = b.statusMethod == null ? null : b.statusMethod.build(Utils.opte(), Utils.opte());
        if (Utils.nn(this.contentMethod)) {
            properties.put(this.contentMethod.getGetter().getName(), this.contentMethod);
        }
        if (Utils.nn(this.statusMethod)) {
            properties.put(this.statusMethod.getGetter().getName(), this.statusMethod);
        }
        this.properties = CollectionUtils.u(properties);
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public int getCode() {
        return this.code;
    }

    public ResponseBeanPropertyMeta getContentMethod() {
        return this.contentMethod;
    }

    public Collection<ResponseBeanPropertyMeta> getHeaderMethods() {
        return this.headerMethods.values();
    }

    public Optional<HttpPartSerializer> getPartSerializer() {
        return this.partSerializer;
    }

    public Collection<ResponseBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    public ResponseBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    public HttpPartSchema getSchema() {
        return this.schema;
    }

    public ResponseBeanPropertyMeta getStatusMethod() {
        return this.statusMethod;
    }

    static class Builder {
        ClassMeta<?> cm;
        int code;
        AnnotationWorkList annotations;
        Class<? extends HttpPartSerializer> partSerializer;
        Class<? extends HttpPartParser> partParser;
        HttpPartSchema.Builder schema = HttpPartSchema.create();
        Map<String, ResponseBeanPropertyMeta.Builder> headerMethods = CollectionUtils.map();
        ResponseBeanPropertyMeta.Builder contentMethod;
        ResponseBeanPropertyMeta.Builder statusMethod;

        Builder(AnnotationWorkList annotations) {
            this.annotations = annotations;
        }

        Builder apply(Response a) {
            if (Utils.nn(a)) {
                if (ClassUtils.isNotVoid(a.serializer())) {
                    this.partSerializer = a.serializer();
                }
                if (ClassUtils.isNotVoid(a.parser())) {
                    this.partParser = a.parser();
                }
                this.schema.apply((Annotation)a.schema());
            }
            return this;
        }

        Builder apply(StatusCode a) {
            if (Utils.nn(a) && a.value().length > 0) {
                this.code = a.value()[0];
            }
            return this;
        }

        Builder apply(Type t) {
            Class<?> c = ClassUtils.toClass(t);
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            this.cm.getPublicMethods().stream().forEach(x -> {
                InvalidAnnotationException.assertNoInvalidAnnotations(x, Query.class, FormData.class);
                if (x.hasAnnotation(Header.class)) {
                    MethodInfoUtils.assertNoArgs(x, Header.class);
                    MethodInfoUtils.assertReturnNotVoid(x, Header.class);
                    HttpPartSchema s = HttpPartSchema.create(x.getAnnotations(Header.class).findFirst().map(AnnotationInfo::inner).orElse(null), x.getPropertyName());
                    this.headerMethods.put(s.getName(), ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_HEADER, s, x));
                } else if (x.hasAnnotation(StatusCode.class)) {
                    MethodInfoUtils.assertNoArgs(x, Header.class);
                    MethodInfoUtils.assertReturnType(x, Header.class, Integer.TYPE, Integer.class);
                    this.statusMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_STATUS, x);
                } else if (x.hasAnnotation(Content.class)) {
                    if (x.getParameterCount() == 0) {
                        MethodInfoUtils.assertReturnNotVoid(x, Header.class);
                    } else {
                        MethodInfoUtils.assertArgType(x, Header.class, OutputStream.class, Writer.class);
                    }
                    this.contentMethod = ResponseBeanPropertyMeta.create(HttpPartType.RESPONSE_BODY, x);
                }
            });
            return this;
        }

        ResponseBeanMeta build() {
            return new ResponseBeanMeta(this);
        }
    }
}

