/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.config;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.BinaryFormat;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.config.Config;
import org.apache.juneau.config.internal.ConfigMap;
import org.apache.juneau.config.internal.ConfigMapEntry;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;

public class Entry {
    private final ConfigMapEntry configEntry;
    private final Config config;
    private final String value;

    private static boolean isArray(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c.isArray();
    }

    private static boolean isSimpleType(Type t) {
        if (!(t instanceof Class)) {
            return false;
        }
        Class c = (Class)t;
        return c == String.class || c.isPrimitive() || c.isAssignableFrom(Number.class) || c == Boolean.class || c.isEnum();
    }

    protected Entry(Config config, ConfigMap configMap, String sectionName, String entryName) {
        this.configEntry = configMap.getEntry(sectionName, entryName);
        this.config = config;
        this.value = this.configEntry == null ? null : config.removeMods(this.configEntry.getModifiers(), this.configEntry.getValue());
    }

    public <T> Optional<T> as(Class<T> type) {
        return this.as(type, new Type[0]);
    }

    public <T> Optional<T> as(Parser parser, Class<T> type) {
        return this.as(parser, type, new Type[0]);
    }

    public <T> Optional<T> as(Parser parser, Type type, Type ... args) {
        if (this.isNull()) {
            return Utils.opte();
        }
        try {
            Object v = this.toString();
            if (type == String.class) {
                return this.asString();
            }
            if (type == String[].class) {
                return this.asStringArray();
            }
            if (type == byte[].class) {
                return this.asBytes();
            }
            if (type == Integer.TYPE || type == Integer.class) {
                return this.asInteger();
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.asLong();
            }
            if (type == JsonMap.class) {
                return this.asMap();
            }
            if (type == JsonList.class) {
                return this.asList();
            }
            if (this.isEmpty()) {
                return Utils.opte();
            }
            if (Entry.isSimpleType(type)) {
                return Utils.opt((Object)this.config.beanSession.convertToType(v, (Class)type));
            }
            if (parser instanceof JsonParser) {
                char s1 = StringUtils.firstNonWhitespaceChar((String)v);
                if (Entry.isArray(type) && s1 != '[') {
                    v = "[" + (String)v + "]";
                } else if (s1 != '[' && s1 != '{' && !"null".equals(v)) {
                    v = "'" + (String)v + "'";
                }
            }
            return Utils.opt((Object)parser.parse((String)v, type, args));
        }
        catch (ParseException e) {
            throw ThrowableUtils.bex((Throwable)e, (Class)null, (String)"Value could not be parsed.", (Object[])new Object[0]);
        }
    }

    public <T> Optional<T> as(Type type, Type ... args) {
        return this.as((Parser)this.config.parser, type, args);
    }

    public Optional<Boolean> asBoolean() {
        return Utils.opt(this.isEmpty() ? null : Boolean.valueOf(Boolean.parseBoolean(this.toString())));
    }

    public Optional<byte[]> asBytes() {
        if (this.isNull()) {
            return Utils.opte();
        }
        String s = this.toString();
        if (s.indexOf(10) != -1) {
            s = s.replace("\n", "");
        }
        try {
            if (this.config.binaryFormat == BinaryFormat.HEX) {
                return Utils.opt((Object)StringUtils.fromHex((String)s));
            }
            if (this.config.binaryFormat == BinaryFormat.SPACED_HEX) {
                return Utils.opt((Object)StringUtils.fromSpacedHex((String)s));
            }
            return Utils.opt((Object)StringUtils.base64Decode((String)s));
        }
        catch (Exception e) {
            throw ThrowableUtils.bex((Throwable)e, (Class)null, (String)"Value could not be converted to a byte array.", (Object[])new Object[0]);
        }
    }

    public Optional<Double> asDouble() {
        return Utils.opt(this.isEmpty() ? null : Double.valueOf(this.toString()));
    }

    public Optional<Float> asFloat() {
        return Utils.opt(this.isEmpty() ? null : Float.valueOf(this.toString()));
    }

    public Optional<Integer> asInteger() {
        return Utils.opt(this.isEmpty() ? null : Integer.valueOf(StringUtils.parseIntWithSuffix((String)this.toString())));
    }

    public Optional<JsonList> asList() throws ParseException {
        return this.asList((Parser)this.config.parser);
    }

    public Optional<JsonList> asList(Parser parser) throws ParseException {
        char s1;
        if (this.isNull()) {
            return Utils.opte();
        }
        if (parser == null) {
            parser = this.config.parser;
        }
        Object s = this.toString();
        if (parser instanceof JsonParser && (s1 = StringUtils.firstNonWhitespaceChar((String)s)) != '[' && !"null".equals(s)) {
            s = "[" + (String)s + "]";
        }
        return Utils.opt((Object)JsonList.ofText((CharSequence)s, (Parser)parser));
    }

    public Optional<Long> asLong() {
        return Utils.opt(this.isEmpty() ? null : Long.valueOf(StringUtils.parseLongWithSuffix((String)this.toString())));
    }

    public Optional<JsonMap> asMap() throws ParseException {
        return this.asMap((Parser)this.config.parser);
    }

    public Optional<JsonMap> asMap(Parser parser) throws ParseException {
        char s1;
        if (this.isNull()) {
            return Utils.opte();
        }
        if (parser == null) {
            parser = this.config.parser;
        }
        Object s = this.toString();
        if (parser instanceof JsonParser && (s1 = StringUtils.firstNonWhitespaceChar((String)s)) != '{' && !"null".equals(s)) {
            s = "{" + (String)s + "}";
        }
        return Utils.opt((Object)JsonMap.ofText((CharSequence)s, (Parser)parser));
    }

    public Optional<String> asString() {
        return Utils.opt(this.isPresent() ? this.config.varSession.resolve(this.value) : null);
    }

    public Optional<String[]> asStringArray() {
        ReaderParser readerParser;
        if (!this.isPresent()) {
            return Utils.opte();
        }
        String v = this.toString();
        char s1 = StringUtils.firstNonWhitespaceChar((String)v);
        char s2 = StringUtils.lastNonWhitespaceChar((String)v);
        if (s1 == '[' && s2 == ']' && (readerParser = this.config.parser) instanceof JsonParser) {
            JsonParser parser2 = (JsonParser)readerParser;
            try {
                return Utils.opt((Object)((String[])parser2.parse(v, String[].class)));
            }
            catch (ParseException e) {
                throw ThrowableUtils.bex((Throwable)e);
            }
        }
        return Utils.opt((Object)StringUtils.splita((String)v));
    }

    public String get() {
        if (this.isNull()) {
            throw new NullPointerException("Value was null");
        }
        return this.toString();
    }

    public String getComment() {
        return this.configEntry.getComment();
    }

    public String getKey() {
        return this.configEntry.getKey();
    }

    public String getModifiers() {
        return this.configEntry.getModifiers();
    }

    public List<String> getPreLines() {
        return this.configEntry.getPreLines();
    }

    public String getValue() {
        return this.configEntry.getValue();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean isPresent() {
        return !this.isNull();
    }

    public String orElse(String def) {
        return this.isNull() ? def : this.get();
    }

    public String orElseGet(Supplier<String> def) {
        return this.isNull() ? def.get() : this.get();
    }

    public String toString() {
        return this.isPresent() ? this.config.varSession.resolve(this.value) : null;
    }

    private boolean isEmpty() {
        return Utils.e((CharSequence)this.value);
    }

    private boolean isNull() {
        return this.value == null;
    }
}

