/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Map;
import java.util.Set;
import org.apache.juneau.bean.openapi3.HeaderInfo;
import org.apache.juneau.bean.openapi3.Link;
import org.apache.juneau.bean.openapi3.MediaType;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Response
extends OpenApiElement {
    private String description;
    private Map<String, HeaderInfo> headers = CollectionUtils.map();
    private Map<String, MediaType> content = CollectionUtils.map();
    private Map<String, Link> links = CollectionUtils.map();

    public Response() {
    }

    public Response(Response copyFrom) {
        super(copyFrom);
        this.description = copyFrom.description;
        if (Utils.nn(copyFrom.headers)) {
            this.headers.putAll(CollectionUtils.copyOf(copyFrom.headers, HeaderInfo::copy));
        }
        if (Utils.nn(copyFrom.content)) {
            this.content.putAll(CollectionUtils.copyOf(copyFrom.content, MediaType::copy));
        }
        if (Utils.nn(copyFrom.links)) {
            this.links.putAll(CollectionUtils.copyOf(copyFrom.links, Link::copy));
        }
    }

    public Response addContent(String key, MediaType value) {
        AssertionUtils.assertArgNotNull("key", key);
        AssertionUtils.assertArgNotNull("value", value);
        this.content.put(key, value);
        return this;
    }

    public Response addHeader(String key, HeaderInfo value) {
        AssertionUtils.assertArgNotNull("key", key);
        AssertionUtils.assertArgNotNull("value", value);
        this.headers.put(key, value);
        return this;
    }

    public Response addLink(String key, Link value) {
        AssertionUtils.assertArgNotNull("key", key);
        AssertionUtils.assertArgNotNull("value", value);
        this.links.put(key, value);
        return this;
    }

    public Response copy() {
        return new Response(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "content" -> ConverterUtils.toType(this.getContent(), type);
            case "headers" -> ConverterUtils.toType(this.getHeaders(), type);
            case "links" -> ConverterUtils.toType(this.getLinks(), type);
            default -> super.get(property, type);
        };
    }

    public Map<String, MediaType> getContent() {
        return Utils.nullIfEmpty(this.content);
    }

    public MediaType getContent(String mediaType) {
        AssertionUtils.assertArgNotNull("mediaType", mediaType);
        return this.content.get(mediaType);
    }

    public String getDescription() {
        return this.description;
    }

    public HeaderInfo getHeader(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return this.headers.get(name);
    }

    public Map<String, HeaderInfo> getHeaders() {
        return Utils.nullIfEmpty(this.headers);
    }

    public Link getLink(String name) {
        AssertionUtils.assertArgNotNull("name", name);
        return this.links.get(name);
    }

    public Map<String, Link> getLinks() {
        return Utils.nullIfEmpty(this.links);
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.content), "content").addIf(Utils.nn(this.description), "description").addIf(Utils.ne(this.headers), "headers").addIf(Utils.ne(this.links), "links").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Response set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "content" -> this.setContent(ConverterUtils.toMapBuilder(value, String.class, MediaType.class).sparse().build());
            case "description" -> this.setDescription(Utils.s(value));
            case "headers" -> this.setHeaders(ConverterUtils.toMapBuilder(value, String.class, HeaderInfo.class).sparse().build());
            case "links" -> this.setLinks(ConverterUtils.toMapBuilder(value, String.class, Link.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Response setContent(Map<String, MediaType> value) {
        this.content.clear();
        if (Utils.nn(value)) {
            this.content.putAll(value);
        }
        return this;
    }

    public Response setDescription(String value) {
        this.description = value;
        return this;
    }

    public Response setHeaders(Map<String, HeaderInfo> value) {
        this.headers.clear();
        if (Utils.nn(value)) {
            this.headers.putAll(value);
        }
        return this;
    }

    public Response setLinks(Map<String, Link> value) {
        this.links.clear();
        if (Utils.nn(value)) {
            this.links.putAll(value);
        }
        return this;
    }

    @Override
    public Response strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected Response strict() {
        super.strict();
        return this;
    }
}

