/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.part;

import java.net.URI;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.part.BasicPart;

public class BasicUriPart
extends BasicPart {
    private final URI value;
    private final Supplier<URI> supplier;

    public static BasicUriPart of(String name, Supplier<URI> value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicUriPart(name, value);
    }

    public static BasicUriPart of(String name, URI value) {
        if (Utils.e(name) || value == null) {
            return null;
        }
        return new BasicUriPart(name, value);
    }

    public BasicUriPart(String name, String value) {
        super(name, value);
        this.value = Utils.e(value) ? null : URI.create(value);
        this.supplier = null;
    }

    public BasicUriPart(String name, Supplier<URI> value) {
        super(name, value);
        this.value = null;
        this.supplier = value;
    }

    public BasicUriPart(String name, URI value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public Optional<URI> asUri() {
        return Utils.opt(this.value());
    }

    public URI orElse(URI other) {
        URI x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public URI toUri() {
        return this.value();
    }

    private URI value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

