/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.juneau.Enablement;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.reflect.ReflectionMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.debug.BasicDebugEnablement;

public abstract class DebugEnablement {
    private final Enablement defaultEnablement;
    private final ReflectionMap<Enablement> enablementMap;
    private final Predicate<HttpServletRequest> conditionalPredicate;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public DebugEnablement(BeanStore beanStore) {
        Builder builder = this.init(beanStore);
        this.defaultEnablement = (Enablement)Utils.firstNonNull((Object[])new Enablement[]{builder.defaultEnablement, Enablement.NEVER});
        this.enablementMap = builder.mapBuilder.build();
        this.conditionalPredicate = (Predicate)Utils.firstNonNull((Object[])new Predicate[]{builder.conditional, x -> Utils.eqic((String)"true", (String)x.getHeader("Debug"))});
    }

    public DebugEnablement(Builder builder) {
        this.defaultEnablement = (Enablement)Utils.firstNonNull((Object[])new Enablement[]{builder.defaultEnablement, Enablement.NEVER});
        this.enablementMap = builder.mapBuilder.build();
        this.conditionalPredicate = (Predicate)Utils.firstNonNull((Object[])new Predicate[]{builder.conditional, x -> Utils.eqic((String)"true", (String)x.getHeader("Debug"))});
    }

    public boolean isDebug(RestContext context, HttpServletRequest req) {
        Class<?> c = context.getResourceClass();
        Enablement e = this.enablementMap.find(c).findFirst().orElse(this.defaultEnablement);
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    public boolean isDebug(RestOpContext context, HttpServletRequest req) {
        Method m = context.getJavaMethod();
        Enablement e = this.enablementMap.find(m).findFirst().orElseGet(() -> this.enablementMap.find(m.getDeclaringClass()).findFirst().orElse(this.defaultEnablement));
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    protected FluentMap<String, Object> properties() {
        return CollectionUtils.filteredBeanPropertyMap().a((Object)"conditionalPredicate", this.conditionalPredicate).a((Object)"defaultEnablement", (Object)this.defaultEnablement).a((Object)"enablementMap", this.enablementMap);
    }

    public String toString() {
        return Utils.r(this.properties());
    }

    protected Builder init(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    protected boolean isConditionallyEnabled(HttpServletRequest req) {
        return this.conditionalPredicate.test(req);
    }

    public static class Builder {
        ReflectionMap.Builder<Enablement> mapBuilder;
        Enablement defaultEnablement = Enablement.NEVER;
        Predicate<HttpServletRequest> conditional;
        BeanCreator<DebugEnablement> creator;

        protected Builder(BeanStore beanStore) {
            this.mapBuilder = ReflectionMap.create(Enablement.class);
            this.defaultEnablement = Enablement.NEVER;
            this.conditional = x -> Utils.eqic((String)"true", (String)x.getHeader("Debug"));
            this.creator = beanStore.createBean(DebugEnablement.class).type(BasicDebugEnablement.class).builder(Builder.class, (Object)this);
        }

        public DebugEnablement build() {
            try {
                return (DebugEnablement)this.creator.run();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        public Builder conditional(Predicate<HttpServletRequest> value) {
            this.conditional = value;
            return this;
        }

        public Builder defaultEnable(Enablement value) {
            this.defaultEnablement = value;
            return this;
        }

        public Builder enable(Enablement enablement, Class<?> ... classes) {
            for (Class<?> c : classes) {
                this.mapBuilder.append(c.getName(), (Object)enablement);
            }
            return this;
        }

        public Builder enable(Enablement enablement, String ... keys) {
            for (String k : keys) {
                this.mapBuilder.append(k, (Object)enablement);
            }
            return this;
        }

        public Builder impl(DebugEnablement value) {
            this.creator.impl((Object)value);
            return this;
        }

        public Builder type(Class<? extends DebugEnablement> value) {
            this.creator.type(value == null ? BasicDebugEnablement.class : value);
            return this;
        }
    }

    public abstract class Void
    extends DebugEnablement {
        Void(BeanStore beanStore) {
            super(beanStore);
        }
    }
}

