/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <log4cxx/logstring.h>
#include <log4cxx/spi/configurator.h>
#include <assert.h>
#include <log4cxx/logger.h>
#include <log4cxx/helpers/singletonholder.h>
#include <log4cxx/helpers/system.h>

#if !defined(LOG4CXX)
	#define LOG4CXX 1
#endif
#include <log4cxx/helpers/aprinitializer.h>

using namespace LOG4CXX_NS;
using namespace LOG4CXX_NS::spi;

IMPLEMENT_LOG4CXX_OBJECT(Configurator)


namespace
{
	struct ConfiguratorTag {};
	using ConfiguratorProperties = std::pair<ConfiguratorTag, helpers::Properties>;

	ConfiguratorProperties& getInstance()
	{
		using ConfiguratorObject = helpers::SingletonHolder<ConfiguratorProperties>;
		auto result = helpers::APRInitializer::getOrAddUnique<ConfiguratorObject>
			( []() -> helpers::ObjectPtr
				{ return std::make_shared<ConfiguratorObject>(); }
			);
		return result->value();
	}
}

Configurator::Configurator()
{
}

helpers::Properties& Configurator::properties()
{
	auto& result = getInstance().second;
	if (result.isEmpty())
		helpers::System::addProgramFilePathComponents(result);
	return result;
}
