/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.ssl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.PemCertificateReader;
import org.apache.nifi.security.ssl.ReadEntityException;

class StandardPemCertificateReader
implements PemCertificateReader {
    static final String CERTIFICATE_HEADER = "-----BEGIN CERTIFICATE-----";
    static final String CERTIFICATE_FOOTER = "-----END CERTIFICATE-----";
    private static final String CERTIFICATE_FACTORY_TYPE = "X.509";
    private static final char LINE_FEED = '\n';
    private static final Charset CERTIFICATE_CHARACTER_SET = StandardCharsets.US_ASCII;

    StandardPemCertificateReader() {
    }

    @Override
    public List<Certificate> readCertificates(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "Input Stream required");
        CertificateFactory certificateFactory = this.getCertificateFactory();
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, CERTIFICATE_CHARACTER_SET));){
            String line = reader.readLine();
            while (line != null) {
                if (CERTIFICATE_HEADER.contentEquals(line)) {
                    Certificate certificate = this.readCertificate(reader, certificateFactory);
                    certificates.add(certificate);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new ReadEntityException("Read certificates failed", e);
        }
        return certificates;
    }

    private Certificate readCertificate(BufferedReader reader, CertificateFactory certificateFactory) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(CERTIFICATE_HEADER);
        builder.append('\n');
        String line = reader.readLine();
        while (line != null) {
            if (CERTIFICATE_FOOTER.contentEquals(line)) {
                builder.append(CERTIFICATE_FOOTER);
                builder.append('\n');
                break;
            }
            builder.append(line);
            builder.append('\n');
            line = reader.readLine();
        }
        String certificate = builder.toString();
        byte[] certificateBytes = certificate.getBytes(CERTIFICATE_CHARACTER_SET);
        ByteArrayInputStream certificateStream = new ByteArrayInputStream(certificateBytes);
        try {
            return certificateFactory.generateCertificate(certificateStream);
        }
        catch (CertificateException e) {
            throw new ReadEntityException("Certificate parsing failed", e);
        }
    }

    private CertificateFactory getCertificateFactory() {
        try {
            return CertificateFactory.getInstance(CERTIFICATE_FACTORY_TYPE);
        }
        catch (CertificateException e) {
            String message = String.format("Certificate Factory Type [%s] creation failed", CERTIFICATE_FACTORY_TYPE);
            throw new BuilderConfigurationException(message, e);
        }
    }
}

