/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.schema.v1;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.minifi.toolkit.schema.ProcessorSchema;
import org.apache.nifi.minifi.toolkit.schema.common.BaseSchema;
import org.apache.nifi.minifi.toolkit.schema.common.CommonPropertyKeys;
import org.apache.nifi.minifi.toolkit.schema.common.ConvertableSchema;

public class ProcessorSchemaV1
extends BaseSchema
implements ConvertableSchema<ProcessorSchema> {
    private String name;
    private String processorClass;
    private String schedulingStrategy;
    private String schedulingPeriod;
    private Number maxConcurrentTasks = 1;
    private String penalizationPeriod = "30 sec";
    private String yieldPeriod = "1 sec";
    private Number runDurationNanos = 0L;
    private List<String> autoTerminatedRelationshipsList = ProcessorSchema.DEFAULT_AUTO_TERMINATED_RELATIONSHIPS_LIST;
    private Map<String, Object> properties = CommonPropertyKeys.DEFAULT_PROPERTIES;

    public ProcessorSchemaV1(Map map) {
        this.name = this.getRequiredKeyAsType(map, "name", String.class, "Processors");
        this.processorClass = this.getRequiredKeyAsType(map, "class", String.class, "Processors");
        this.schedulingStrategy = this.getRequiredKeyAsType(map, "scheduling strategy", String.class, "Processors");
        if (this.schedulingStrategy != null && !ProcessorSchema.isSchedulingStrategy(this.schedulingStrategy)) {
            this.addValidationIssue("scheduling strategy", "Processors", "it is not a valid scheduling strategy");
        }
        this.schedulingPeriod = this.getRequiredKeyAsType(map, "scheduling period", String.class, "Processors");
        this.maxConcurrentTasks = this.getOptionalKeyAsType(map, "max concurrent tasks", Number.class, "Processors", 1);
        this.penalizationPeriod = this.getOptionalKeyAsType(map, "penalization period", String.class, "Processors", "30 sec");
        this.yieldPeriod = this.getOptionalKeyAsType(map, "yield period", String.class, "Processors", "1 sec");
        this.runDurationNanos = this.getOptionalKeyAsType(map, "run duration nanos", Number.class, "Processors", 0L);
        this.autoTerminatedRelationshipsList = this.getOptionalKeyAsType(map, "auto-terminated relationships list", List.class, "Processors", ProcessorSchema.DEFAULT_AUTO_TERMINATED_RELATIONSHIPS_LIST);
        this.properties = this.getOptionalKeyAsType(map, "Properties", Map.class, "Processors", CommonPropertyKeys.DEFAULT_PROPERTIES);
    }

    @Override
    public ProcessorSchema convert() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("class", this.processorClass);
        map.put("max concurrent tasks", this.maxConcurrentTasks);
        map.put("scheduling strategy", this.schedulingStrategy);
        map.put("scheduling period", this.schedulingPeriod);
        map.put("penalization period", this.penalizationPeriod);
        map.put("yield period", this.yieldPeriod);
        map.put("run duration nanos", this.runDurationNanos);
        map.put("auto-terminated relationships list", this.autoTerminatedRelationshipsList);
        map.put("Properties", new HashMap<String, Object>(this.properties));
        return new ProcessorSchema(map);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

