/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.util.Assert;

public class MapUserCredentialRepository
implements UserCredentialRepository {
    private final Map<Bytes, CredentialRecord> credentialIdToUserCredential = new HashMap<Bytes, CredentialRecord>();
    private final Map<Bytes, Set<Bytes>> userEntityIdToUserCredentialIds = new HashMap<Bytes, Set<Bytes>>();

    @Override
    public void delete(Bytes credentialId) {
        Set<Bytes> credentialIds;
        Assert.notNull((Object)credentialId, (String)"credentialId cannot be null");
        CredentialRecord credentialRecord = this.credentialIdToUserCredential.remove(credentialId);
        if (credentialRecord != null && (credentialIds = this.userEntityIdToUserCredentialIds.get(credentialRecord.getUserEntityUserId())) != null) {
            credentialIds.remove(credentialId);
        }
    }

    @Override
    public void save(CredentialRecord credentialRecord) {
        Assert.notNull((Object)credentialRecord, (String)"credentialRecord cannot be null");
        this.credentialIdToUserCredential.put(credentialRecord.getCredentialId(), credentialRecord);
        this.userEntityIdToUserCredentialIds.computeIfAbsent(credentialRecord.getUserEntityUserId(), id -> new HashSet()).add(credentialRecord.getCredentialId());
    }

    @Override
    public CredentialRecord findByCredentialId(Bytes credentialId) {
        Assert.notNull((Object)credentialId, (String)"credentialId cannot be null");
        return this.credentialIdToUserCredential.get(credentialId);
    }

    @Override
    public List<CredentialRecord> findByUserId(Bytes userId) {
        Assert.notNull((Object)userId, (String)"userId cannot be null");
        Set credentialIds = this.userEntityIdToUserCredentialIds.getOrDefault(userId, Collections.emptySet());
        return credentialIds.stream().map(this::findByCredentialId).collect(Collectors.toUnmodifiableList());
    }
}

