/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.logging;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.FlywayDbWebsiteLinks;

public class PreviewFeatureWarning {
    @Generated
    private static final Log LOG = LogFactory.getLog(PreviewFeatureWarning.class);
    private static final List<String> LOGGED_FEATURES = new ArrayList<String>();
    public static final String NATIVE_CONNECTORS = "Native Connectors";

    public static boolean isPreviewFeatureEnabled(String featureName, String environmentVariable, boolean showHowToEnable) {
        if (System.getenv(environmentVariable) != null) {
            PreviewFeatureWarning.logPreviewFeature(featureName);
            return true;
        }
        if (showHowToEnable) {
            LOG.debug("Preview feature '" + featureName + "' is disabled.");
            LOG.debug("Enable it by setting the environment variable " + environmentVariable + "=true");
        }
        return false;
    }

    public static void logPreviewFeature(String featureName) {
        if (LOGGED_FEATURES.contains(featureName)) {
            return;
        }
        String link = featureName.startsWith(NATIVE_CONNECTORS) ? FlywayDbWebsiteLinks.FEEDBACK_SURVEY_LINK : "DatabaseDevOps@red-gate.com";
        LOG.info("-----------------------------------------------------------------------------");
        LOG.info("You are using a preview feature '" + featureName + "'.");
        LOG.info("Please report any issues you encounter to " + link);
        LOG.info("-----------------------------------------------------------------------------");
        LOGGED_FEATURES.add(featureName);
    }
}

