/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.flow;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.FlowClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class CreateFlow
extends AbstractNiFiRegistryCommand<StringResult> {
    public CreateFlow() {
        super("create-flow", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a flow in the given bucket with the given name and description.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.FLOW_NAME.createOption());
        this.addOption(CommandOption.FLOW_DESC.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws ParseException, IOException, NiFiRegistryException {
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        String flowName = this.getRequiredArg(properties, CommandOption.FLOW_NAME);
        String flowDesc = this.getArg(properties, CommandOption.FLOW_DESC);
        VersionedFlow flow = new VersionedFlow();
        flow.setName(flowName);
        flow.setDescription(flowDesc);
        flow.setBucketIdentifier(bucketId);
        FlowClient flowClient = client.getFlowClient();
        VersionedFlow createdFlow = flowClient.create(flow);
        return new StringResult(createdFlow.getIdentifier(), this.getContext().isInteractive());
    }
}

