/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.autoconfigure;

import jakarta.transaction.TransactionManager;
import java.util.HashMap;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyNameAliases;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.boot.jdbc.XADataSourceWrapper;
import org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration;
import org.springframework.boot.jdbc.autoconfigure.DataSourceProperties;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.autoconfigure.PropertiesJdbcConnectionDetails;
import org.springframework.boot.transaction.jta.autoconfigure.JtaAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@AutoConfiguration(before={DataSourceAutoConfiguration.class}, after={JtaAutoConfiguration.class})
@EnableConfigurationProperties(value={DataSourceProperties.class})
@ConditionalOnClass(value={DataSource.class, TransactionManager.class, EmbeddedDatabaseType.class})
@ConditionalOnBean(value={XADataSourceWrapper.class})
@ConditionalOnMissingBean(value={DataSource.class})
public final class XADataSourceAutoConfiguration
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    @Bean
    @ConditionalOnMissingBean(value={JdbcConnectionDetails.class})
    PropertiesJdbcConnectionDetails jdbcConnectionDetails(DataSourceProperties properties) {
        return new PropertiesJdbcConnectionDetails(properties);
    }

    @Bean
    DataSource dataSource(XADataSourceWrapper wrapper, DataSourceProperties properties, JdbcConnectionDetails connectionDetails, ObjectProvider<XADataSource> xaDataSource) throws Exception {
        return wrapper.wrapDataSource((XADataSource)xaDataSource.getIfAvailable(() -> this.createXaDataSource(properties, connectionDetails)));
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private XADataSource createXaDataSource(DataSourceProperties properties, JdbcConnectionDetails connectionDetails) {
        String className = connectionDetails.getXaDataSourceClassName();
        Assert.state((boolean)StringUtils.hasLength((String)className), (String)"No XA DataSource class name specified");
        XADataSource dataSource = this.createXaDataSourceInstance(className);
        this.bindXaProperties(dataSource, properties, connectionDetails);
        return dataSource;
    }

    private XADataSource createXaDataSourceInstance(String className) {
        try {
            Class dataSourceClass = ClassUtils.forName((String)className, (ClassLoader)this.classLoader);
            Object instance = BeanUtils.instantiateClass((Class)dataSourceClass);
            Assert.state((boolean)(instance instanceof XADataSource), () -> "DataSource class " + className + " is not an XADataSource");
            return (XADataSource)instance;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create XADataSource instance from '" + className + "'");
        }
    }

    private void bindXaProperties(XADataSource target, DataSourceProperties dataSourceProperties, JdbcConnectionDetails connectionDetails) {
        Binder binder = new Binder(new ConfigurationPropertySource[]{this.getBinderSource(dataSourceProperties, connectionDetails)});
        binder.bind(ConfigurationPropertyName.EMPTY, Bindable.ofInstance((Object)target));
    }

    private ConfigurationPropertySource getBinderSource(DataSourceProperties dataSourceProperties, JdbcConnectionDetails connectionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>(dataSourceProperties.getXa().getProperties());
        properties.computeIfAbsent("user", key -> connectionDetails.getUsername());
        properties.computeIfAbsent("password", key -> connectionDetails.getPassword());
        try {
            properties.computeIfAbsent("url", key -> connectionDetails.getJdbcUrl());
        }
        catch (DataSourceProperties.DataSourceBeanCreationException dataSourceBeanCreationException) {
            // empty catch block
        }
        MapConfigurationPropertySource source = new MapConfigurationPropertySource(properties);
        ConfigurationPropertyNameAliases aliases = new ConfigurationPropertyNameAliases();
        aliases.addAliases("user", new String[]{"username"});
        return source.withAliases(aliases);
    }
}

