/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1.category;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.controller.GenericLegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.TypeController;
import org.apache.qpid.server.management.plugin.controller.v6_1.category.LegacyCategoryController;
import org.apache.qpid.server.model.AlternateBinding;
import org.apache.qpid.server.model.ConfiguredObject;

public class DestinationController
extends LegacyCategoryController {
    private static final String ALTERNATE_BINDING = "alternateBinding";

    DestinationController(LegacyManagementController legacyManagementController, String name, String[] parentCategories, String defaultType, Set<TypeController> typeControllers) {
        super(legacyManagementController, name, parentCategories, defaultType, typeControllers);
    }

    @Override
    public Map<String, Object> convertAttributesToNextVersion(ConfiguredObject<?> root, List<String> path, Map<String, Object> attributes) {
        if (attributes.containsKey("alternateExchange")) {
            LinkedHashMap<String, Object> converted = new LinkedHashMap<String, Object>(attributes);
            String alternateExchange = (String)converted.remove("alternateExchange");
            LegacyConfiguredObject exchange = this.findExchange(root, path, object -> alternateExchange.equals(object.getAttribute("id")) || alternateExchange.equals(object.getAttribute("name")));
            if (exchange == null) {
                throw ManagementException.createBadRequestManagementException(String.format("Cannot find alternate exchange '%s'", alternateExchange));
            }
            converted.put(ALTERNATE_BINDING, Map.of("destination", exchange.getAttribute("name")));
            return converted;
        }
        return attributes;
    }

    private LegacyConfiguredObject findExchange(ConfiguredObject<?> root, List<String> path, Predicate<LegacyConfiguredObject> predicate) {
        Collection<String> hierarchy = this.getNextVersionManagementController().getCategoryHierarchy(root, "Exchange");
        List<String> exchangePath = path.size() > hierarchy.size() - 1 ? path.subList(0, hierarchy.size() - 1) : path;
        Object result = this.getNextVersionManagementController().get(root, "Exchange", exchangePath, Map.of());
        if (result instanceof Collection) {
            Collection exchanges = (Collection)result;
            return exchanges.stream().filter(LegacyConfiguredObject.class::isInstance).map(LegacyConfiguredObject.class::cast).filter(predicate).findFirst().orElse(null);
        }
        throw ManagementException.createBadRequestManagementException("Cannot find alternate exchange");
    }

    public static class LegacyDestination
    extends GenericLegacyConfiguredObject {
        static final String ALTERNATE_EXCHANGE = "alternateExchange";

        LegacyDestination(LegacyManagementController managementController, LegacyConfiguredObject nextVersionDestination, String category) {
            super(managementController, nextVersionDestination, category);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return Stream.concat(super.getAttributeNames().stream(), Stream.of(ALTERNATE_EXCHANGE)).collect(Collectors.toSet());
        }

        @Override
        public Object getAttribute(String name) {
            return this.getAttributeInternal(name, false);
        }

        @Override
        public Object getActualAttribute(String name) {
            return this.getAttributeInternal(name, true);
        }

        protected Object getAttributeInternal(String name, boolean isActual) {
            if (ALTERNATE_EXCHANGE.equals(name)) {
                Object altBinding = this.getAttribute(DestinationController.ALTERNATE_BINDING, isActual);
                if (altBinding instanceof AlternateBinding) {
                    AlternateBinding alternateBinding = (AlternateBinding)altBinding;
                    Collection<LegacyConfiguredObject> exchanges = this.getNextVersionLegacyConfiguredObject().getParent("VirtualHost").getChildren("Exchange");
                    LegacyConfiguredObject altExchange = exchanges.stream().filter(e -> alternateBinding.getDestination().equals(e.getAttribute("name"))).findFirst().orElse(null);
                    if (altExchange != null) {
                        return this.getManagementController().convertFromNextVersion(altExchange);
                    }
                }
                return null;
            }
            return this.getAttribute(name, isActual);
        }

        Object getAttribute(String name, boolean isActual) {
            if (isActual) {
                return super.getActualAttribute(name);
            }
            return super.getAttribute(name);
        }

        @Override
        public boolean isSecureAttribute(String name) {
            if (ALTERNATE_EXCHANGE.equals(name)) {
                return super.isSecureAttribute(DestinationController.ALTERNATE_BINDING);
            }
            return super.isSecureAttribute(name);
        }

        @Override
        public boolean isOversizedAttribute(String name) {
            if (ALTERNATE_EXCHANGE.equals(name)) {
                return super.isOversizedAttribute(DestinationController.ALTERNATE_BINDING);
            }
            return super.isOversizedAttribute(name);
        }
    }
}

