/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import java.util.EnumSet;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.AsArraySerializerBase;

public class EnumSetSerializer
extends AsArraySerializerBase<EnumSet<? extends Enum<?>>> {
    public EnumSetSerializer(JavaType elemType) {
        super(EnumSet.class, elemType, true, null, null);
    }

    public EnumSetSerializer(EnumSetSerializer src, TypeSerializer vts, ValueSerializer<?> valueSerializer, Boolean unwrapSingle, BeanProperty property) {
        super(src, vts, valueSerializer, unwrapSingle, property);
    }

    protected EnumSetSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    protected EnumSetSerializer withResolved(BeanProperty property, TypeSerializer vts, ValueSerializer<?> elementSerializer, Boolean unwrapSingle) {
        return new EnumSetSerializer(this, vts, elementSerializer, unwrapSingle, property);
    }

    @Override
    public boolean isEmpty(SerializationContext prov, EnumSet<? extends Enum<?>> value) {
        return value.isEmpty();
    }

    @Override
    public boolean hasSingleElement(EnumSet<? extends Enum<?>> value) {
        return value.size() == 1;
    }

    @Override
    public final void serialize(EnumSet<? extends Enum<?>> value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        int len = value.size();
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray(value, len);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(EnumSet<? extends Enum<?>> value, JsonGenerator gen, SerializationContext ctxt) throws JacksonException {
        gen.assignCurrentValue(value);
        ValueSerializer<Object> enumSer = this._elementSerializer;
        for (Enum enum_ : value) {
            if (enumSer == null) {
                enumSer = this._findAndAddDynamic(ctxt, enum_.getDeclaringClass());
            }
            enumSer.serialize(enum_, gen, ctxt);
        }
    }
}

