/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TopicQueueLock {
    private final int size;
    private final List<Lock> lockList;

    public TopicQueueLock() {
        this.size = 32;
        this.lockList = new ArrayList<Lock>(32);
        for (int i = 0; i < this.size; ++i) {
            this.lockList.add(new ReentrantLock());
        }
    }

    public TopicQueueLock(int size) {
        this.size = size;
        this.lockList = new ArrayList<Lock>(size);
        for (int i = 0; i < this.size; ++i) {
            this.lockList.add(new ReentrantLock());
        }
    }

    public void lock(String topicQueueKey) {
        Lock lock = this.lockList.get((topicQueueKey.hashCode() & Integer.MAX_VALUE) % this.size);
        lock.lock();
    }

    public void unlock(String topicQueueKey) {
        Lock lock = this.lockList.get((topicQueueKey.hashCode() & Integer.MAX_VALUE) % this.size);
        lock.unlock();
    }
}

