/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction.queue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.transaction.AbstractTransactionalMessageCheckListener;
import org.apache.rocketmq.broker.transaction.OperationResult;
import org.apache.rocketmq.broker.transaction.TransactionMetrics;
import org.apache.rocketmq.broker.transaction.TransactionalMessageService;
import org.apache.rocketmq.broker.transaction.queue.GetResult;
import org.apache.rocketmq.broker.transaction.queue.MessageQueueOpContext;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageBridge;
import org.apache.rocketmq.broker.transaction.queue.TransactionalMessageUtil;
import org.apache.rocketmq.broker.transaction.queue.TransactionalOpBatchService;
import org.apache.rocketmq.client.consumer.PullResult;
import org.apache.rocketmq.client.consumer.PullStatus;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.header.EndTransactionRequestHeader;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.config.BrokerRole;

public class TransactionalMessageServiceImpl
implements TransactionalMessageService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private TransactionalMessageBridge transactionalMessageBridge;
    private static final int PULL_MSG_RETRY_NUMBER = 1;
    private static final int MAX_PROCESS_TIME_LIMIT = 60000;
    private static final int MAX_RETRY_TIMES_FOR_ESCAPE = 10;
    private static final int MAX_RETRY_COUNT_WHEN_HALF_NULL = 1;
    private static final int OP_MSG_PULL_NUMS = 32;
    private static final int SLEEP_WHILE_NO_OP = 1000;
    private final ConcurrentHashMap<Integer, MessageQueueOpContext> deleteContext = new ConcurrentHashMap();
    private ServiceThread transactionalOpBatchService;
    private ConcurrentHashMap<MessageQueue, MessageQueue> opQueueMap = new ConcurrentHashMap();
    private TransactionMetrics transactionMetrics;

    public TransactionalMessageServiceImpl(TransactionalMessageBridge transactionBridge) {
        this.transactionalMessageBridge = transactionBridge;
        this.transactionalOpBatchService = new TransactionalOpBatchService(this.transactionalMessageBridge.getBrokerController(), this);
        this.transactionalOpBatchService.start();
        this.transactionMetrics = new TransactionMetrics(BrokerPathConfigHelper.getTransactionMetricsPath(this.transactionalMessageBridge.getBrokerController().getMessageStoreConfig().getStorePathRootDir()));
        this.transactionMetrics.load();
    }

    @Override
    public TransactionMetrics getTransactionMetrics() {
        return this.transactionMetrics;
    }

    @Override
    public void setTransactionMetrics(TransactionMetrics transactionMetrics) {
        this.transactionMetrics = transactionMetrics;
    }

    @Override
    public CompletableFuture<PutMessageResult> asyncPrepareMessage(MessageExtBrokerInner messageInner) {
        return this.transactionalMessageBridge.asyncPutHalfMessage(messageInner);
    }

    @Override
    public PutMessageResult prepareMessage(MessageExtBrokerInner messageInner) {
        return this.transactionalMessageBridge.putHalfMessage(messageInner);
    }

    private boolean needDiscard(MessageExt msgExt, int transactionCheckMax) {
        String checkTimes = msgExt.getProperty("TRANSACTION_CHECK_TIMES");
        int checkTime = 1;
        if (null != checkTimes) {
            checkTime = this.getInt(checkTimes);
            if (checkTime >= transactionCheckMax) {
                return true;
            }
            ++checkTime;
        }
        msgExt.putUserProperty("TRANSACTION_CHECK_TIMES", String.valueOf(checkTime));
        return false;
    }

    private boolean needSkip(MessageExt msgExt) {
        long valueOfCurrentMinusBorn = System.currentTimeMillis() - msgExt.getBornTimestamp();
        if (valueOfCurrentMinusBorn > (long)this.transactionalMessageBridge.getBrokerController().getMessageStoreConfig().getFileReservedTime() * 3600L * 1000L) {
            log.info("Half message exceed file reserved time ,so skip it.messageId {},bornTime {}", (Object)msgExt.getMsgId(), (Object)msgExt.getBornTimestamp());
            return true;
        }
        return false;
    }

    private boolean putBackHalfMsgQueue(MessageExt msgExt, long offset) {
        PutMessageResult putMessageResult = this.putBackToHalfQueueReturnResult(msgExt);
        if (putMessageResult != null && putMessageResult.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
            msgExt.setQueueOffset(putMessageResult.getAppendMessageResult().getLogicsOffset());
            msgExt.setCommitLogOffset(putMessageResult.getAppendMessageResult().getWroteOffset());
            msgExt.setMsgId(putMessageResult.getAppendMessageResult().getMsgId());
            log.debug("Send check message, the offset={} restored in queueOffset={} commitLogOffset={} newMsgId={} realMsgId={} topic={}", new Object[]{offset, msgExt.getQueueOffset(), msgExt.getCommitLogOffset(), msgExt.getMsgId(), msgExt.getUserProperty("UNIQ_KEY"), msgExt.getTopic()});
            return true;
        }
        log.error("PutBackToHalfQueueReturnResult write failed, topic: {}, queueId: {}, msgId: {}", new Object[]{msgExt.getTopic(), msgExt.getQueueId(), msgExt.getMsgId()});
        return false;
    }

    @Override
    public void check(long transactionTimeout, int transactionCheckMax, AbstractTransactionalMessageCheckListener listener) {
        try {
            String topic = "RMQ_SYS_TRANS_HALF_TOPIC";
            Set<MessageQueue> msgQueues = this.transactionalMessageBridge.fetchMessageQueues(topic);
            if (msgQueues == null || msgQueues.size() == 0) {
                log.warn("The queue of topic is empty :" + topic);
                return;
            }
            log.debug("Check topic={}, queues={}", (Object)topic, msgQueues);
            for (MessageQueue messageQueue : msgQueues) {
                long newOpOffset;
                long startTime = System.currentTimeMillis();
                MessageQueue opQueue = this.getOpQueue(messageQueue);
                long halfOffset = this.transactionalMessageBridge.fetchConsumeOffset(messageQueue);
                long opOffset = this.transactionalMessageBridge.fetchConsumeOffset(opQueue);
                log.info("Before check, the queue={} msgOffset={} opOffset={}", new Object[]{messageQueue, halfOffset, opOffset});
                if (halfOffset < 0L || opOffset < 0L) {
                    log.error("MessageQueue: {} illegal offset read: {}, op offset: {},skip this queue", new Object[]{messageQueue, halfOffset, opOffset});
                    continue;
                }
                HashMap<Long, Long> removeMap = new HashMap<Long, Long>();
                HashMap<Long, HashSet<Long>> opMsgMap = new HashMap<Long, HashSet<Long>>();
                ArrayList<Long> doneOpOffset = new ArrayList<Long>();
                PullResult pullResult = this.fillOpRemoveMap(removeMap, opQueue, opOffset, halfOffset, opMsgMap, doneOpOffset);
                if (null == pullResult) {
                    log.error("The queue={} check msgOffset={} with opOffset={} failed, pullResult is null", new Object[]{messageQueue, halfOffset, opOffset});
                    continue;
                }
                int getMessageNullCount = 1;
                long newOffset = halfOffset;
                long i = halfOffset;
                long nextOpOffset = pullResult.getNextBeginOffset();
                int putInQueueCount = 0;
                int escapeFailCnt = 0;
                while (true) {
                    if (System.currentTimeMillis() - startTime > 60000L) {
                        log.info("Queue={} process time reach max={}", (Object)messageQueue, (Object)60000);
                        break;
                    }
                    Long removedOpOffset = removeMap.remove(i);
                    if (removedOpOffset != null) {
                        log.debug("Half offset {} has been committed/rolled back", (Object)i);
                        opMsgMap.get(removedOpOffset).remove(i);
                        if (opMsgMap.get(removedOpOffset).size() == 0) {
                            opMsgMap.remove(removedOpOffset);
                            doneOpOffset.add(removedOpOffset);
                        }
                    } else {
                        boolean isNeedCheck;
                        GetResult getResult = this.getHalfMsg(messageQueue, i);
                        MessageExt msgExt = getResult.getMsg();
                        if (msgExt == null) {
                            if (getMessageNullCount++ > 1) break;
                            if (getResult.getPullResult().getPullStatus() == PullStatus.NO_NEW_MSG) {
                                log.debug("No new msg, the miss offset={} in={}, continue check={}, pull result={}", new Object[]{i, messageQueue, getMessageNullCount, getResult.getPullResult()});
                                break;
                            }
                            log.info("Illegal offset, the miss offset={} in={}, continue check={}, pull result={}", new Object[]{i, messageQueue, getMessageNullCount, getResult.getPullResult()});
                            newOffset = i = getResult.getPullResult().getNextBeginOffset();
                            continue;
                        }
                        if (this.transactionalMessageBridge.getBrokerController().getBrokerConfig().isEnableSlaveActingMaster() && this.transactionalMessageBridge.getBrokerController().getMinBrokerIdInGroup() == this.transactionalMessageBridge.getBrokerController().getBrokerIdentity().getBrokerId() && BrokerRole.SLAVE.equals((Object)this.transactionalMessageBridge.getBrokerController().getMessageStoreConfig().getBrokerRole())) {
                            MessageExtBrokerInner msgInner = this.transactionalMessageBridge.renewHalfMessageInner(msgExt);
                            boolean isSuccess = this.transactionalMessageBridge.escapeMessage(msgInner);
                            if (isSuccess) {
                                escapeFailCnt = 0;
                                newOffset = i + 1L;
                                ++i;
                                continue;
                            }
                            log.warn("Escaping transactional message failed {} times! msgId(offsetId)={}, UNIQ_KEY(transactionId)={}", new Object[]{escapeFailCnt + 1, msgExt.getMsgId(), msgExt.getUserProperty("UNIQ_KEY")});
                            if (escapeFailCnt < 10) {
                                Thread.sleep(100L * (long)(2 ^ ++escapeFailCnt));
                                continue;
                            }
                            escapeFailCnt = 0;
                            newOffset = i + 1L;
                            ++i;
                            continue;
                        }
                        if (this.needDiscard(msgExt, transactionCheckMax) || this.needSkip(msgExt)) {
                            listener.resolveDiscardMsg(msgExt);
                            newOffset = i + 1L;
                            ++i;
                            continue;
                        }
                        if (msgExt.getStoreTimestamp() >= startTime) {
                            log.debug("Fresh stored. the miss offset={}, check it later, store={}", (Object)i, (Object)new Date(msgExt.getStoreTimestamp()));
                            break;
                        }
                        long valueOfCurrentMinusBorn = System.currentTimeMillis() - msgExt.getBornTimestamp();
                        long checkImmunityTime = transactionTimeout;
                        String checkImmunityTimeStr = msgExt.getUserProperty("CHECK_IMMUNITY_TIME_IN_SECONDS");
                        if (null != checkImmunityTimeStr) {
                            checkImmunityTime = this.getImmunityTime(checkImmunityTimeStr, transactionTimeout);
                            if (valueOfCurrentMinusBorn <= checkImmunityTime && this.checkPrepareQueueOffset(removeMap, doneOpOffset, msgExt, checkImmunityTimeStr)) {
                                newOffset = i + 1L;
                                ++i;
                                continue;
                            }
                        } else if (0L <= valueOfCurrentMinusBorn && valueOfCurrentMinusBorn <= checkImmunityTime) {
                            log.debug("New arrived, the miss offset={}, check it later checkImmunity={}, born={}", new Object[]{i, checkImmunityTime, new Date(msgExt.getBornTimestamp())});
                            break;
                        }
                        List opMsg = pullResult == null ? null : pullResult.getMsgFoundList();
                        boolean bl = isNeedCheck = opMsg == null && valueOfCurrentMinusBorn > checkImmunityTime || opMsg != null && ((MessageExt)opMsg.get(opMsg.size() - 1)).getBornTimestamp() - startTime > transactionTimeout || valueOfCurrentMinusBorn <= -1L;
                        if (isNeedCheck) {
                            if (!this.putBackHalfMsgQueue(msgExt, i)) continue;
                            ++putInQueueCount;
                            log.info("Check transaction. real_topic={},uniqKey={},offset={},commitLogOffset={}", new Object[]{msgExt.getUserProperty("REAL_TOPIC"), msgExt.getUserProperty("UNIQ_KEY"), msgExt.getQueueOffset(), msgExt.getCommitLogOffset()});
                            listener.resolveHalfMsg(msgExt);
                        } else {
                            nextOpOffset = pullResult != null ? pullResult.getNextBeginOffset() : nextOpOffset;
                            if ((pullResult = this.fillOpRemoveMap(removeMap, opQueue, nextOpOffset, halfOffset, opMsgMap, doneOpOffset)) == null || pullResult.getPullStatus() == PullStatus.NO_NEW_MSG || pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL || pullResult.getPullStatus() == PullStatus.NO_MATCHED_MSG) {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            log.info("The miss message offset:{}, pullOffsetOfOp:{}, miniOffset:{} get more opMsg.", new Object[]{i, nextOpOffset, halfOffset});
                            continue;
                        }
                    }
                    newOffset = i + 1L;
                    ++i;
                }
                if (newOffset != halfOffset) {
                    this.transactionalMessageBridge.updateConsumeOffset(messageQueue, newOffset);
                }
                if ((newOpOffset = this.calculateOpOffset(doneOpOffset, opOffset)) != opOffset) {
                    this.transactionalMessageBridge.updateConsumeOffset(opQueue, newOpOffset);
                }
                GetResult getResult = this.getHalfMsg(messageQueue, newOffset);
                pullResult = this.pullOpMsg(opQueue, newOpOffset, 1);
                long maxMsgOffset = getResult.getPullResult() == null ? newOffset : getResult.getPullResult().getMaxOffset();
                long maxOpOffset = pullResult == null ? newOpOffset : pullResult.getMaxOffset();
                long msgTime = getResult.getMsg() == null ? System.currentTimeMillis() : getResult.getMsg().getStoreTimestamp();
                log.info("After check, {} opOffset={} opOffsetDiff={} msgOffset={} msgOffsetDiff={} msgTime={} msgTimeDelayInMs={} putInQueueCount={}", new Object[]{messageQueue, newOpOffset, maxOpOffset - newOpOffset, newOffset, maxMsgOffset - newOffset, new Date(msgTime), System.currentTimeMillis() - msgTime, putInQueueCount});
            }
        }
        catch (Throwable e) {
            log.error("Check error", e);
        }
    }

    private long getImmunityTime(String checkImmunityTimeStr, long transactionTimeout) {
        long checkImmunityTime = this.getLong(checkImmunityTimeStr);
        checkImmunityTime = -1L == checkImmunityTime ? transactionTimeout : (checkImmunityTime *= 1000L);
        return checkImmunityTime;
    }

    private PullResult fillOpRemoveMap(HashMap<Long, Long> removeMap, MessageQueue opQueue, long pullOffsetOfOp, long miniOffset, Map<Long, HashSet<Long>> opMsgMap, List<Long> doneOpOffset) {
        PullResult pullResult = this.pullOpMsg(opQueue, pullOffsetOfOp, 32);
        if (null == pullResult) {
            return null;
        }
        if (pullResult.getPullStatus() == PullStatus.OFFSET_ILLEGAL || pullResult.getPullStatus() == PullStatus.NO_MATCHED_MSG) {
            log.warn("The miss op offset={} in queue={} is illegal, pullResult={}", new Object[]{pullOffsetOfOp, opQueue, pullResult});
            this.transactionalMessageBridge.updateConsumeOffset(opQueue, pullResult.getNextBeginOffset());
            return pullResult;
        }
        if (pullResult.getPullStatus() == PullStatus.NO_NEW_MSG) {
            log.warn("The miss op offset={} in queue={} is NO_NEW_MSG, pullResult={}", new Object[]{pullOffsetOfOp, opQueue, pullResult});
            return pullResult;
        }
        List opMsg = pullResult.getMsgFoundList();
        if (opMsg == null) {
            log.warn("The miss op offset={} in queue={} is empty, pullResult={}", new Object[]{pullOffsetOfOp, opQueue, pullResult});
            return pullResult;
        }
        for (MessageExt opMessageExt : opMsg) {
            if (opMessageExt.getBody() == null) {
                log.error("op message body is null. queueId={}, offset={}", (Object)opMessageExt.getQueueId(), (Object)opMessageExt.getQueueOffset());
                doneOpOffset.add(opMessageExt.getQueueOffset());
                continue;
            }
            HashSet<Long> set = new HashSet<Long>();
            String queueOffsetBody = new String(opMessageExt.getBody(), TransactionalMessageUtil.CHARSET);
            log.debug("Topic: {} tags: {}, OpOffset: {}, HalfOffset: {}", new Object[]{opMessageExt.getTopic(), opMessageExt.getTags(), opMessageExt.getQueueOffset(), queueOffsetBody});
            if ("d".equals(opMessageExt.getTags())) {
                String[] offsetArray;
                for (String offset : offsetArray = queueOffsetBody.split(",")) {
                    Long offsetValue = this.getLong(offset);
                    if (offsetValue < miniOffset) continue;
                    removeMap.put(offsetValue, opMessageExt.getQueueOffset());
                    set.add(offsetValue);
                }
            } else {
                log.error("Found a illegal tag in opMessageExt= {} ", (Object)opMessageExt);
            }
            if (set.size() > 0) {
                opMsgMap.put(opMessageExt.getQueueOffset(), set);
                continue;
            }
            doneOpOffset.add(opMessageExt.getQueueOffset());
        }
        log.debug("Remove map: {}", removeMap);
        log.debug("Done op list: {}", doneOpOffset);
        log.debug("opMsg map: {}", opMsgMap);
        return pullResult;
    }

    private boolean checkPrepareQueueOffset(HashMap<Long, Long> removeMap, List<Long> doneOpOffset, MessageExt msgExt, String checkImmunityTimeStr) {
        String prepareQueueOffsetStr = msgExt.getUserProperty("TRAN_PREPARED_QUEUE_OFFSET");
        if (null == prepareQueueOffsetStr) {
            return this.putImmunityMsgBackToHalfQueue(msgExt);
        }
        long prepareQueueOffset = this.getLong(prepareQueueOffsetStr);
        if (-1L == prepareQueueOffset) {
            return false;
        }
        Long tmpOpOffset = removeMap.remove(prepareQueueOffset);
        if (tmpOpOffset != null) {
            doneOpOffset.add(tmpOpOffset);
            log.info("removeMap contain prepareQueueOffset. real_topic={},uniqKey={},immunityTime={},offset={}", new Object[]{msgExt.getUserProperty("REAL_TOPIC"), msgExt.getUserProperty("UNIQ_KEY"), checkImmunityTimeStr, msgExt.getQueueOffset()});
            return true;
        }
        return this.putImmunityMsgBackToHalfQueue(msgExt);
    }

    private PutMessageResult putBackToHalfQueueReturnResult(MessageExt messageExt) {
        PutMessageResult putMessageResult = null;
        try {
            MessageExtBrokerInner msgInner = this.transactionalMessageBridge.renewHalfMessageInner(messageExt);
            putMessageResult = this.transactionalMessageBridge.putMessageReturnResult(msgInner);
        }
        catch (Exception e) {
            log.warn("PutBackToHalfQueueReturnResult error", (Throwable)e);
        }
        return putMessageResult;
    }

    private boolean putImmunityMsgBackToHalfQueue(MessageExt messageExt) {
        MessageExtBrokerInner msgInner = this.transactionalMessageBridge.renewImmunityHalfMessageInner(messageExt);
        return this.transactionalMessageBridge.putMessage(msgInner);
    }

    private PullResult pullHalfMsg(MessageQueue mq, long offset, int nums) {
        return this.transactionalMessageBridge.getHalfMessage(mq.getQueueId(), offset, nums);
    }

    private PullResult pullOpMsg(MessageQueue mq, long offset, int nums) {
        return this.transactionalMessageBridge.getOpMessage(mq.getQueueId(), offset, nums);
    }

    private Long getLong(String s) {
        long v = -1L;
        try {
            v = Long.parseLong(s);
        }
        catch (Exception e) {
            log.error("GetLong error", (Throwable)e);
        }
        return v;
    }

    private Integer getInt(String s) {
        int v = -1;
        try {
            v = Integer.parseInt(s);
        }
        catch (Exception e) {
            log.error("GetInt error", (Throwable)e);
        }
        return v;
    }

    private long calculateOpOffset(List<Long> doneOffset, long oldOffset) {
        Collections.sort(doneOffset);
        long newOffset = oldOffset;
        for (int i = 0; i < doneOffset.size() && doneOffset.get(i) == newOffset; ++newOffset, ++i) {
        }
        return newOffset;
    }

    private MessageQueue getOpQueue(MessageQueue messageQueue) {
        MessageQueue opQueue = this.opQueueMap.get(messageQueue);
        if (opQueue == null) {
            opQueue = new MessageQueue(TransactionalMessageUtil.buildOpTopic(), messageQueue.getBrokerName(), messageQueue.getQueueId());
            this.opQueueMap.put(messageQueue, opQueue);
        }
        return opQueue;
    }

    private GetResult getHalfMsg(MessageQueue messageQueue, long offset) {
        GetResult getResult = new GetResult();
        PullResult result = this.pullHalfMsg(messageQueue, offset, 1);
        if (result != null) {
            getResult.setPullResult(result);
            List messageExts = result.getMsgFoundList();
            if (messageExts == null || messageExts.size() == 0) {
                return getResult;
            }
            getResult.setMsg((MessageExt)messageExts.get(0));
        }
        return getResult;
    }

    private OperationResult getHalfMessageByOffset(long commitLogOffset) {
        OperationResult response = new OperationResult();
        MessageExt messageExt = this.transactionalMessageBridge.lookMessageByOffset(commitLogOffset);
        if (messageExt != null) {
            response.setPrepareMessage(messageExt);
            response.setResponseCode(0);
        } else {
            response.setResponseCode(1);
            response.setResponseRemark("Find prepared transaction message failed");
        }
        return response;
    }

    @Override
    public boolean deletePrepareMessage(MessageExt messageExt) {
        MessageQueueOpContext old;
        Integer queueId = messageExt.getQueueId();
        MessageQueueOpContext mqContext = this.deleteContext.get(queueId);
        if (mqContext == null && (old = this.deleteContext.putIfAbsent(queueId, mqContext = new MessageQueueOpContext(System.currentTimeMillis(), 20000))) != null) {
            mqContext = old;
        }
        String data = messageExt.getQueueOffset() + ",";
        try {
            boolean res = mqContext.getContextQueue().offer(data, 100L, TimeUnit.MILLISECONDS);
            if (res) {
                int totalSize = mqContext.getTotalSize().addAndGet(data.length());
                if (totalSize > this.transactionalMessageBridge.getBrokerController().getBrokerConfig().getTransactionOpMsgMaxSize()) {
                    this.transactionalOpBatchService.wakeup();
                }
                return true;
            }
            this.transactionalOpBatchService.wakeup();
        }
        catch (InterruptedException res) {
            // empty catch block
        }
        Message msg = this.getOpMessage(queueId, data);
        if (this.transactionalMessageBridge.writeOp(queueId, msg)) {
            log.warn("Force add remove op data. queueId={}", (Object)queueId);
            return true;
        }
        log.error("Transaction op message write failed. messageId is {}, queueId is {}", (Object)messageExt.getMsgId(), (Object)messageExt.getQueueId());
        return false;
    }

    @Override
    public OperationResult commitMessage(EndTransactionRequestHeader requestHeader) {
        return this.getHalfMessageByOffset(requestHeader.getCommitLogOffset());
    }

    @Override
    public OperationResult rollbackMessage(EndTransactionRequestHeader requestHeader) {
        return this.getHalfMessageByOffset(requestHeader.getCommitLogOffset());
    }

    @Override
    public boolean open() {
        return true;
    }

    @Override
    public void close() {
        if (this.transactionalOpBatchService != null) {
            this.transactionalOpBatchService.shutdown();
        }
        this.getTransactionMetrics().persist();
    }

    public Message getOpMessage(int queueId, String moreData) {
        int maxSize;
        String opTopic = TransactionalMessageUtil.buildOpTopic();
        MessageQueueOpContext mqContext = this.deleteContext.get(queueId);
        int moreDataLength = moreData != null ? moreData.length() : 0;
        int length = moreDataLength;
        if (length < (maxSize = this.transactionalMessageBridge.getBrokerController().getBrokerConfig().getTransactionOpMsgMaxSize())) {
            int sz = mqContext.getTotalSize().get();
            length = sz > maxSize || length + sz > maxSize ? maxSize + 100 : (length += sz);
        }
        StringBuilder sb = new StringBuilder(length);
        if (moreData != null) {
            sb.append(moreData);
        }
        while (!mqContext.getContextQueue().isEmpty() && sb.length() < maxSize) {
            String data = mqContext.getContextQueue().poll();
            if (data == null) continue;
            sb.append(data);
        }
        if (sb.length() == 0) {
            return null;
        }
        int l = sb.length() - moreDataLength;
        mqContext.getTotalSize().addAndGet(-l);
        mqContext.setLastWriteTimestamp(System.currentTimeMillis());
        return new Message(opTopic, "d", sb.toString().getBytes(TransactionalMessageUtil.CHARSET));
    }

    public long batchSendOpMessage() {
        long startTime = System.currentTimeMillis();
        try {
            long firstTimestamp = startTime;
            HashMap<Integer, Message> sendMap = null;
            long interval = this.transactionalMessageBridge.getBrokerController().getBrokerConfig().getTransactionOpBatchInterval();
            int maxSize = this.transactionalMessageBridge.getBrokerController().getBrokerConfig().getTransactionOpMsgMaxSize();
            boolean overSize = false;
            for (Map.Entry<Integer, MessageQueueOpContext> entry : this.deleteContext.entrySet()) {
                Message opMsg;
                MessageQueueOpContext mqContext = entry.getValue();
                if (mqContext.getTotalSize().get() <= 0 || mqContext.getContextQueue().size() == 0 || mqContext.getTotalSize().get() < maxSize && startTime - mqContext.getLastWriteTimestamp() < interval) continue;
                if (sendMap == null) {
                    sendMap = new HashMap<Integer, Message>();
                }
                if ((opMsg = this.getOpMessage(entry.getKey(), null)) == null) continue;
                sendMap.put(entry.getKey(), opMsg);
                firstTimestamp = Math.min(firstTimestamp, mqContext.getLastWriteTimestamp());
                if (mqContext.getTotalSize().get() < maxSize) continue;
                overSize = true;
            }
            if (sendMap != null) {
                for (Map.Entry<Integer, MessageQueueOpContext> entry : sendMap.entrySet()) {
                    if (this.transactionalMessageBridge.writeOp(entry.getKey(), (Message)entry.getValue())) continue;
                    log.error("Transaction batch op message write failed. body is {}, queueId is {}", (Object)new String(((Message)entry.getValue()).getBody(), TransactionalMessageUtil.CHARSET), (Object)entry.getKey());
                }
            }
            log.debug("Send op message queueIds={}", sendMap == null ? null : sendMap.keySet());
            long wakeupTimestamp = firstTimestamp + interval;
            if (!overSize && wakeupTimestamp > startTime) {
                return wakeupTimestamp;
            }
        }
        catch (Throwable t) {
            log.error("batchSendOp error.", t);
        }
        return 0L;
    }

    public Map<Integer, MessageQueueOpContext> getDeleteContext() {
        return this.deleteContext;
    }
}

