/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.sis.referencing.factory.sql.CloseableReference;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.internal.shared.AbstractMap;
import org.apache.sis.util.internal.shared.Strings;

final class AuthorityCodes
extends AbstractMap<String, String>
implements Serializable {
    private static final int MAX_CODE = 69999999;
    private static final int ALL_CODES = 0;
    private static final int NAME_FOR_CODE = 1;
    private static final int CODES_FOR_NAME = 2;
    private static final int NUM_QUERIES = 3;
    private final transient EPSGDataAccess factory;
    final Object cacheKey;
    private final transient String[] sql;
    private final transient Statement[] statements;
    private transient ResultSet results;
    private transient IntegerList codes;

    AuthorityCodes(TableInfo table, Object object, EPSGDataAccess factory) throws SQLException {
        this.factory = factory;
        this.sql = new String[3];
        this.statements = new Statement[3];
        StringBuilder buffer = new StringBuilder(100);
        int columnNameStart = buffer.append("SELECT ").length();
        int columnNameEnd = buffer.append(table.codeColumn).length();
        buffer.append(" FROM ").append(table.fromClause);
        this.cacheKey = table.appendWhere(factory, object, buffer);
        int conditionStart = buffer.length();
        if (factory.owner.showDeprecated) {
            buffer.append("TRUE");
        } else {
            if (table.showColumn != null) {
                buffer.append(table.showColumn).append("=TRUE AND ");
            }
            buffer.append("DEPRECATED=FALSE");
        }
        this.sql[0] = buffer.append(" ORDER BY ").append(table.codeColumn).toString();
        this.sql[2] = buffer.insert(conditionStart, table.nameColumn + "=? AND ").toString();
        buffer.setLength(conditionStart);
        buffer.replace(columnNameStart, columnNameEnd, table.nameColumn);
        this.sql[1] = buffer.append(table.codeColumn).append("=?").toString();
        for (int i = 0; i < 3; ++i) {
            this.sql[i] = factory.translator.apply(this.sql[i]);
        }
    }

    final CloseableReference createReference() {
        return new CloseableReference(this, this.factory, this.statements);
    }

    private PreparedStatement prepareStatement(int index) throws SQLException {
        PreparedStatement statement = (PreparedStatement)this.statements[index];
        if (statement == null) {
            statement = this.factory.connection.prepareStatement(this.sql[index]);
            this.statements[index] = statement;
            this.sql[index] = null;
        }
        return statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void findCodesFromName(String name, Collection<Integer> addTo) throws SQLException {
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            PreparedStatement statement = this.prepareStatement(2);
            statement.setString(1, name);
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    int code = result.getInt(1);
                    if (result.wasNull()) continue;
                    addTo.add(code);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean getAllCodes(Collection<Integer> addTo) throws SQLException {
        boolean changed = false;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int code;
            int index = 0;
            while ((code = this.getCodeAt(index)) >= 0) {
                changed |= addTo.add(code);
                ++index;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCodeAt(int index) throws SQLException {
        int code;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int more;
            if (this.codes == null) {
                this.codes = new IntegerList(100, 69999999);
                this.statements[0] = this.factory.connection.createStatement();
                this.results = this.statements[0].executeQuery(this.sql[0]);
                this.sql[0] = null;
            }
            if ((more = index - this.codes.size()) < 0) {
                code = this.codes.getInt(index);
            } else {
                ResultSet r = this.results;
                if (r == null) {
                    code = -1;
                } else {
                    do {
                        if (!r.next()) {
                            this.results = null;
                            r.close();
                            this.statements[0].close();
                            this.statements[0] = null;
                            return -1;
                        }
                        code = r.getInt(1);
                        this.codes.addInt(code);
                    } while (--more >= 0);
                }
            }
        }
        return code;
    }

    public boolean isEmpty() {
        try {
            return this.getCodeAt(0) < 0;
        }
        catch (SQLException exception) {
            throw AuthorityCodes.factoryFailure(exception);
        }
    }

    public int size() {
        try {
            this.getCodeAt(Integer.MAX_VALUE);
        }
        catch (SQLException exception) {
            throw AuthorityCodes.factoryFailure(exception);
        }
        return this.codes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String get(Object code) {
        int n;
        if (code == null) return null;
        if (code instanceof Number) {
            n = ((Number)code).intValue();
        } else {
            try {
                n = Integer.parseInt(code.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        try {
            EPSGDataAccess e = this.factory;
            synchronized (e) {
                PreparedStatement statement = this.prepareStatement(1);
                statement.setInt(1, n);
                try (ResultSet r = statement.executeQuery();){
                    String name;
                    do {
                        if (!r.next()) return null;
                    } while ((name = r.getString(1)) == null);
                    String string = name;
                    return string;
                }
            }
        }
        catch (SQLException exception) {
            throw AuthorityCodes.factoryFailure(exception);
        }
    }

    public AbstractMap.EntryIterator<String, String> entryIterator() {
        return new AbstractMap.EntryIterator<String, String>(){
            private int index = -1;
            private int code;

            protected boolean next() {
                try {
                    this.code = AuthorityCodes.this.getCodeAt(++this.index);
                }
                catch (SQLException exception) {
                    throw AuthorityCodes.factoryFailure(exception);
                }
                return this.code >= 0;
            }

            protected String getKey() {
                return String.valueOf(this.code);
            }

            protected String getValue() {
                return "";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String size = null;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            if (this.codes != null) {
                size = "size" + (this.results != null ? " \u2265 " : " = ") + this.codes.size();
            }
        }
        return Strings.toString(this.getClass(), (Object[])new Object[]{"cacheKey", this.cacheKey, null, size});
    }

    private static BackingStoreException factoryFailure(SQLException exception) {
        return new BackingStoreException(exception.getLocalizedMessage(), (Throwable)exception);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashMap(this);
    }
}

