/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.internal.shared.AttributeConvention;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.filter.DynamicOptimization;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.filter.base.Node;
import org.apache.sis.filter.base.WarningEvent;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class Optimization {
    private static final Object COMPUTING = Void.TYPE;
    private Set<DefaultFeatureType> featureTypes = Set.of();
    private Map<Object, Object> done;
    private Object currentFilterOrExpression;
    private boolean isImprovable;

    @Deprecated(since="1.6", forRemoval=true)
    public DefaultFeatureType getFeatureType() {
        return (DefaultFeatureType)Containers.peekIfSingleton(this.getFinalFeatureTypes());
    }

    @Deprecated(since="1.6", forRemoval=true)
    public void setFeatureType(DefaultFeatureType type) {
        this.setFinalFeatureType(type);
    }

    public Set<DefaultFeatureType> getFinalFeatureTypes() {
        return this.featureTypes;
    }

    public void setFinalFeatureTypes(Collection<? extends DefaultFeatureType> types) {
        this.featureTypes = Set.copyOf(types);
    }

    public final void setFinalFeatureType(DefaultFeatureType type) {
        this.setFinalFeatureTypes(type != null ? Set.of(type) : Set.of());
    }

    final <R> R constantResultForAllTypes(Function<DefaultFeatureType, R> mapper) {
        R value;
        Iterator<DefaultFeatureType> it = this.getFinalFeatureTypes().iterator();
        if (it.hasNext() && (value = mapper.apply(it.next())) != null) {
            while (it.hasNext()) {
                if (value.equals(mapper.apply(it.next()))) continue;
                return null;
            }
            return value;
        }
        return null;
    }

    final String getPreferredPropertyName(String property, Set<String> addTo) throws IllegalArgumentException {
        HashMap<DefaultFeatureType, IllegalArgumentException> exceptions = new HashMap<DefaultFeatureType, IllegalArgumentException>();
        for (DefaultFeatureType type : this.getFinalFeatureTypes()) {
            try {
                addTo.add(Features.getLinkTarget(type.getProperty(property)).orElse(property));
            }
            catch (IllegalArgumentException e) {
                exceptions.putIfAbsent(type, e);
            }
        }
        if (exceptions.isEmpty()) {
            String name = (String)Containers.peekIfSingleton(addTo);
            return name != null ? name : property;
        }
        IllegalArgumentException e = (IllegalArgumentException)Optimization.valueOfBaseType(exceptions);
        while (!exceptions.isEmpty()) {
            e.addSuppressed((Throwable)Optimization.valueOfBaseType(exceptions));
        }
        throw e;
    }

    private static <E> E valueOfBaseType(Map<DefaultFeatureType, E> map) {
        E e = map.remove(Features.findCommonParent(map.keySet()));
        if (e == null) {
            Iterator<E> it = map.values().iterator();
            e = it.next();
            it.remove();
        }
        return e;
    }

    public Optional<CoordinateReferenceSystem> findExpectedCRS(Expression<?, ?> parameter) throws IllegalArgumentException {
        CoordinateReferenceSystem crs = null;
        if (parameter instanceof Literal) {
            crs = Geometries.getCoordinateReferenceSystem(((Literal)parameter).getValue());
        } else if (parameter instanceof ValueReference) {
            String xpath = ((ValueReference)parameter).getXPath();
            crs = this.constantResultForAllTypes(type -> AttributeConvention.getCRSCharacteristic(type, type.getProperty(xpath)));
        }
        return Optional.ofNullable(crs);
    }

    private <T> boolean isImprovable(T source, BiPredicate<T, Set<Object>> isOptimizable) {
        if (this.isImprovable || this.featureTypes.isEmpty()) {
            return isOptimizable.test(source, new HashSet());
        }
        return false;
    }

    private static boolean isOptimizable(Filter<?> filter, Set<Object> done) {
        if (filter instanceof OnFilter) {
            return true;
        }
        for (Expression<?, ?> parameter : filter.getExpressions()) {
            if (!done.add(parameter) || !Optimization.isOptimizable(parameter, done)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOptimizable(Expression<?, ?> expression, Set<Object> done) {
        if (expression instanceof OnExpression) {
            return true;
        }
        for (Expression<?, ?> parameter : expression.getParameters()) {
            if (!done.add(parameter) || !Optimization.isOptimizable(parameter, done)) continue;
            return true;
        }
        return false;
    }

    private static boolean isImmediate(Expression<?, ?>[] effective) {
        int i = effective.length;
        while (--i >= 0) {
            if (effective[i] instanceof Literal) continue;
            return false;
        }
        return true;
    }

    private boolean convertLiterals(Expression<?, ?>[] effective) {
        Class type = null;
        for (Expression<?, ?> e : effective) {
            if (!(e instanceof FeatureExpression) || e instanceof Literal) continue;
            type = Classes.findCommonClass(type, ((FeatureExpression)e).getResultClass());
        }
        boolean changed = false;
        if (type != null && type != Object.class) {
            int i = effective.length;
            while (--i >= 0) {
                Expression<?, ?> e = effective[i];
                if (!(e instanceof Literal)) continue;
                try {
                    Object value = ((Literal)e).getValue();
                    if (value == (value = ObjectConverters.convert(value, (Class)type))) continue;
                    effective[i] = Optimization.literal(value);
                    changed = true;
                }
                catch (UnconvertibleObjectException ex) {
                    this.warning((Exception)((Object)ex), false);
                }
            }
        }
        return changed;
    }

    private boolean isFirstCall() {
        if (this.done != null) {
            return false;
        }
        this.isImprovable = false;
        this.done = new IdentityHashMap<Object, Object>();
        return true;
    }

    private <T> Object previousResult(T original, Function<T, Object> identification) {
        this.currentFilterOrExpression = original;
        Object previous = this.done.putIfAbsent(original, COMPUTING);
        if (previous != COMPUTING) {
            return previous;
        }
        throw new IllegalArgumentException(Errors.format((short)152, (Object)identification.apply(original)));
    }

    private void storeResult(Object original, Object result) {
        if (this.done.put(original, result) != COMPUTING) {
            throw new ConcurrentModificationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Filter<R> apply(Filter<R> filter) {
        if (filter instanceof OnFilter) {
            OnFilter original = (OnFilter)filter;
            boolean isFirstCall = this.isFirstCall();
            Object oldFilterOrExpression = this.currentFilterOrExpression;
            try {
                filter = (Filter)this.previousResult(original, Filter::getOperatorType);
                if (filter == null) {
                    filter = original.optimize(this);
                    this.storeResult(original, filter);
                }
            }
            finally {
                this.currentFilterOrExpression = oldFilterOrExpression;
                if (isFirstCall) {
                    this.done = null;
                }
            }
            if (isFirstCall && this.isImprovable(filter, Optimization::isOptimizable)) {
                filter = DynamicOptimization.ofAny(filter);
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, V> Expression<R, ? extends V> apply(Expression<R, ? extends V> expression) {
        if (expression instanceof OnExpression) {
            OnExpression original = (OnExpression)expression;
            boolean isFirstCall = this.isFirstCall();
            Object oldFilterOrExpression = this.currentFilterOrExpression;
            try {
                expression = (Expression)this.previousResult(original, Expression::getFunctionName);
                if (expression == null) {
                    expression = original.optimize(this);
                    this.storeResult(original, expression);
                }
                if (isFirstCall && this.isImprovable(expression, Optimization::isOptimizable)) {
                    expression = DynamicOptimization.ofAny(expression);
                }
            }
            finally {
                this.currentFilterOrExpression = oldFilterOrExpression;
                if (isFirstCall) {
                    this.done = null;
                }
            }
        }
        return expression;
    }

    public <R> List<Filter<R>> applyAndDecompose(Filter<R> filter) {
        return Optimization.toAndOperands(this.apply(filter));
    }

    private static <R> List<Filter<R>> toAndOperands(Filter<R> filter) {
        Filter<R> nop;
        if (filter == null) {
            return List.of();
        }
        Enum<?> type = filter.getOperatorType();
        if (type == LogicalOperatorName.AND) {
            return ((LogicalOperator)filter).getOperands();
        }
        if (type == LogicalOperatorName.NOT && (nop = Optimization.getNotOperand(filter)).getOperatorType() == LogicalOperatorName.OR) {
            List operands = ((LogicalOperator)nop).getOperands();
            ArrayList<Filter<R>> result = new ArrayList<Filter<R>>(operands.size());
            for (Filter operand : operands) {
                operand = operand.getOperatorType() == LogicalOperatorName.NOT ? Optimization.getNotOperand(operand) : new LogicalFilter.Not(operand);
                result.add(operand);
            }
            return result;
        }
        return List.of(filter);
    }

    private static <R> Filter<R> getNotOperand(Filter<R> filter) {
        Filter operand = (Filter)Containers.peekIfSingleton(((LogicalOperator)filter).getOperands());
        if (operand != null) {
            return operand;
        }
        throw new IllegalArgumentException();
    }

    public void warning(Exception exception, boolean resolvable) {
        this.isImprovable |= resolvable;
        Consumer<WarningEvent> listener = WarningEvent.LISTENER.get();
        if (listener != null) {
            listener.accept(new WarningEvent(this.currentFilterOrExpression, exception, true));
        } else {
            Logging.recoverableException((Logger)Node.LOGGER, Optimization.class, (String)"apply", (Throwable)exception);
        }
    }

    public static Set<FunctionProperty> properties(Filter<?> filter) {
        return Node.transitiveProperties(filter.getExpressions());
    }

    public static Set<FunctionProperty> properties(Expression<?, ?> expression) {
        return Node.properties(expression);
    }

    public static <R, V> Expression<R, V> literal(V value) {
        if (value == null) {
            return LeafExpression.NULL();
        }
        return new LeafExpression.Literal(value);
    }

    public static interface OnFilter<R>
    extends Filter<R> {
        default public Filter<R> optimize(Optimization optimization) {
            Expression[] effective = (Expression[])this.getExpressions().toArray(Expression[]::new);
            Filter<Object> optimized = this;
            boolean changed = false;
            for (int i = 0; i < effective.length; ++i) {
                Expression e = effective[i];
                if (e == (e = optimization.apply(e))) continue;
                effective[i] = e;
                changed = true;
            }
            if (this instanceof Node && ((Node)((Object)this)).allowLiteralConversions()) {
                changed |= optimization.convertLiterals(effective);
            }
            if (changed) {
                optimized = this.recreate(effective);
            }
            if (Optimization.isImmediate(effective)) {
                return optimized.test((Object)null) ? Filter.include() : Filter.exclude();
            }
            return optimized;
        }

        default public Filter<R> recreate(Expression<R, ?>[] effective) {
            return this;
        }

        private Filter<R> castOrNull(Predicate<? super R> other) {
            Class to;
            Class type;
            if (other instanceof Filter && (type = this.getResourceClass()) != null && (to = ((Filter)other).getResourceClass()) != null && type.isAssignableFrom(to)) {
                return (Filter)other;
            }
            return null;
        }

        @Override
        default public Predicate<R> and(Predicate<? super R> other) {
            Filter<? super R> filter = this.castOrNull(other);
            if (filter != null) {
                return new LogicalFilter.And<R>(this, filter);
            }
            return Filter.super.and(other);
        }

        @Override
        default public Predicate<R> or(Predicate<? super R> other) {
            Filter<? super R> filter = this.castOrNull(other);
            if (filter != null) {
                return new LogicalFilter.Or<R>(this, filter);
            }
            return Filter.super.and(other);
        }

        @Override
        default public Predicate<R> negate() {
            return new LogicalFilter.Not(this);
        }
    }

    public static interface OnExpression<R, V>
    extends Expression<R, V> {
        default public Expression<R, ? extends V> optimize(Optimization optimization) {
            Expression[] effective = (Expression[])this.getParameters().toArray(Expression[]::new);
            Expression<Object, V> optimized = this;
            boolean changed = false;
            for (int i = 0; i < effective.length; ++i) {
                Expression e = effective[i];
                if (e == (e = optimization.apply(e))) continue;
                effective[i] = e;
                changed = true;
            }
            if (this instanceof Node && ((Node)((Object)this)).allowLiteralConversions()) {
                changed |= optimization.convertLiterals(effective);
            }
            if (changed) {
                optimized = this.recreate(effective);
            }
            if (Optimization.isImmediate(effective) && !Optimization.properties(this).contains(FunctionProperty.VOLATILE)) {
                return Optimization.literal(optimized.apply((Object)null));
            }
            return optimized;
        }

        default public Expression<R, V> recreate(Expression<R, ?>[] effective) {
            return this;
        }
    }
}

