/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NamespaceResolverImpl
extends AbstractNamespaceResolver {
    private static Logger log = LoggerFactory.getLogger(NamespaceResolverImpl.class);
    private Map<String, String> prefixToURI = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();

    NamespaceResolverImpl() {
    }

    void add(String prefix, String uri) {
        this.prefixToURI.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    void remove(String prefix, String uri) {
        this.prefixToURI.remove(prefix);
        this.uriToPrefix.remove(uri);
    }

    Map<String, String> getNamespaces() {
        return Collections.unmodifiableMap(this.prefixToURI);
    }

    @Override
    public String getURI(String prefix) throws NamespaceException {
        String uri = this.prefixToURI.get(prefix);
        if (uri == null) {
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }
        return uri;
    }

    @Override
    public String getPrefix(String uri) throws NamespaceException {
        String prefix = this.uriToPrefix.get(uri);
        if (prefix == null) {
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
        return prefix;
    }
}

