/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.spi;

import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ProgressTracker {
    protected ProgressTrackerListener listener;
    private ProgressTrackerListener.Mode mode = ProgressTrackerListener.Mode.TEXT;
    private boolean enabled = true;

    public ProgressTracker() {
    }

    public ProgressTracker(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public void setListener(ProgressTrackerListener listener) {
        this.listener = listener;
    }

    public ProgressTrackerListener getListener() {
        return this.listener;
    }

    public void track(String action, String path) {
        if (this.enabled && this.listener != null) {
            this.listener.onMessage(this.mode, action, path);
        }
    }

    public void track(Exception e, String path) {
        if (this.enabled && this.listener != null) {
            this.listener.onError(this.mode, path, e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ProgressTrackerListener.Mode getMode() {
        return this.mode;
    }

    public ProgressTrackerListener.Mode setMode(ProgressTrackerListener.Mode mode) {
        ProgressTrackerListener.Mode prev = this.mode;
        this.mode = mode;
        return prev;
    }
}

