/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.File;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.util.Constants;

public class PathUtil {
    public static String[] makePath(String[] parent, String path) {
        if (path == null || path.equals("") || path.equals(".")) {
            return parent;
        }
        boolean isAbsolute = false;
        String[] composed = Text.explode(path, 47);
        if (path.charAt(0) == '/') {
            isAbsolute = true;
        } else if (parent != null && parent.length > 0) {
            int off = 0;
            if (parent[0].equals("/")) {
                isAbsolute = true;
                off = 1;
            }
            String[] c = new String[parent.length - off + composed.length];
            System.arraycopy(parent, off, c, 0, parent.length - off);
            System.arraycopy(composed, 0, c, parent.length - off, composed.length);
            composed = c;
        }
        int dst = 0;
        boolean startsWithParent = false;
        for (int i = 0; i < composed.length; ++i) {
            String element = composed[i];
            if (element.equals(".")) continue;
            if (element.equals("..")) {
                if (dst == 0) {
                    startsWithParent = true;
                }
                if (startsWithParent) {
                    composed[dst++] = element;
                    continue;
                }
                --dst;
                continue;
            }
            composed[dst++] = element;
        }
        if (isAbsolute) {
            String[] ret = new String[dst + 1];
            System.arraycopy(composed, 0, ret, 1, dst);
            ret[0] = "/";
            return ret;
        }
        if (dst == composed.length) {
            return composed;
        }
        String[] ret = new String[dst];
        System.arraycopy(composed, 0, ret, 0, dst);
        return ret;
    }

    public static String makePath(String parent, String relPath) {
        String[] ret = PathUtil.makePath(Text.explode(parent, 47), relPath);
        return "/" + Text.implode(ret, "/");
    }

    public static File getRelativeFile(File parent, File file) {
        return new File(PathUtil.getRelativeFilePath(parent.getPath(), file.getPath()));
    }

    public static String getRelativePath(String parent, String path) {
        return PathUtil.getRelativeFilePath(parent, path, "/");
    }

    public static String getRelativeFilePath(String cwd, String path) {
        return PathUtil.getRelativeFilePath(cwd, path, Constants.FS_NATIVE);
    }

    public static String getRelativeFilePath(String cwd, String path, String separator) {
        int i;
        if (cwd.equals(path)) {
            return ".";
        }
        if (!(path.startsWith(separator) || path.length() >= 2 && path.charAt(1) == ':' && path.charAt(2) == '\\')) {
            return path;
        }
        String[] p1 = Text.explode(cwd, separator.charAt(0));
        String[] p2 = Text.explode(path, separator.charAt(0));
        for (i = 0; i < p1.length && i < p2.length && p1[i].equals(p2[i]); ++i) {
        }
        StringBuffer buf = new StringBuffer();
        String delim = "";
        for (int j = i; j < p1.length; ++j) {
            buf.append(delim).append("..");
            delim = separator;
        }
        while (i < p2.length) {
            buf.append(delim).append(p2[i++]);
            delim = separator;
        }
        return buf.toString();
    }

    public static String append(String parent, String relPath) {
        if (relPath == null || relPath.length() == 0) {
            return parent == null ? "" : parent;
        }
        StringBuffer ret = new StringBuffer();
        if (parent != null) {
            ret.append(parent);
        }
        if (ret.length() > 0 && ret.charAt(ret.length() - 1) != '/') {
            ret.append('/');
        }
        ret.append(relPath);
        return ret.toString();
    }

    public static int getDepth(String path) {
        int len = path.length();
        if (len <= 1) {
            return 0;
        }
        int depth = 1;
        for (int i = 1; i < len; ++i) {
            if (path.charAt(i) != '/') continue;
            ++depth;
        }
        return depth;
    }

    public static String getPath(Node parent, String relPath) throws RepositoryException {
        String path = parent.getPath();
        if (relPath.length() > 0) {
            path = path.endsWith("/") ? path + relPath : path + "/" + relPath;
        }
        return path;
    }
}

