/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.sync.content;

import java.util.Objects;
import org.apache.sling.ide.util.PathUtil;

public class WorkspacePath {
    private final String portablePath;

    public WorkspacePath(String portablePath) {
        if (portablePath == null) {
            throw new IllegalArgumentException("Invalid path :'" + portablePath + "'");
        }
        if (portablePath.length() > 1 && portablePath.endsWith("/")) {
            portablePath = portablePath.substring(0, portablePath.length() - 1);
        }
        this.portablePath = portablePath;
    }

    public String getName() {
        return PathUtil.getName(this.portablePath);
    }

    public String asPortableString() {
        return this.portablePath;
    }

    public WorkspacePath relativize(WorkspacePath other) {
        String ours = this.absolute().portablePath;
        String theirs = other.absolute().portablePath;
        if (ours.equals(theirs)) {
            return new WorkspacePath("");
        }
        if (theirs.startsWith(ours)) {
            return new WorkspacePath(theirs.substring(ours.length() + 1));
        }
        return null;
    }

    public boolean isRoot() {
        return this.portablePath.equals("/");
    }

    public WorkspacePath getParent() {
        String path = PathUtil.getParent(this.portablePath);
        if (path == null) {
            return null;
        }
        return new WorkspacePath(path);
    }

    public WorkspacePath absolute() {
        if (this.isAbsolute()) {
            return this;
        }
        return new WorkspacePath("/" + this.portablePath);
    }

    private boolean isAbsolute() {
        return this.portablePath.charAt(0) == '/';
    }

    public WorkspacePath append(String name) {
        if (name == null || name.isEmpty() || name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Invalid name: '" + name + "'");
        }
        return new WorkspacePath(this.portablePath + "/" + name);
    }

    public WorkspacePath append(WorkspacePath other) {
        if (other == null) {
            throw new IllegalArgumentException("Unable to append null path");
        }
        return new WorkspacePath(PathUtil.join(this.portablePath, other.portablePath));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorkspacePath)) {
            return false;
        }
        return Objects.equals(this.portablePath, ((WorkspacePath)obj).portablePath);
    }

    public String toString() {
        return this.asPortableString();
    }
}

