/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.sync.content.impl;

import java.nio.file.Path;
import java.util.List;
import org.apache.sling.ide.sync.content.WorkspaceDirectory;
import org.apache.sling.ide.sync.content.WorkspaceFile;
import org.apache.sling.ide.sync.content.WorkspacePath;
import org.apache.sling.ide.sync.content.WorkspacePaths;
import org.apache.sling.ide.sync.content.WorkspaceProject;
import org.apache.sling.ide.sync.content.WorkspaceResource;

public class NonExistingDirectory
implements WorkspaceDirectory {
    private final WorkspacePath path;
    private final WorkspaceProject project;

    public NonExistingDirectory(WorkspacePath path, WorkspaceProject project) {
        this.path = path;
        this.project = project;
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public WorkspacePath getLocalPath() {
        return this.path;
    }

    @Override
    public Path getOSPath() {
        return WorkspacePaths.toOsPath(this.path);
    }

    @Override
    public WorkspaceProject getProject() {
        return this.project;
    }

    @Override
    public long getLastModified() {
        throw new IllegalArgumentException("Directory at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public Object getTransientProperty(String propertyName) {
        throw new IllegalArgumentException("Directory at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public WorkspaceFile getFile(WorkspacePath relativePath) {
        throw new IllegalArgumentException("Directory at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public WorkspaceDirectory getDirectory(WorkspacePath relativePath) {
        throw new IllegalArgumentException("Directory at " + String.valueOf(this.path) + " does not exist");
    }

    @Override
    public List<WorkspaceResource> getChildren() {
        throw new IllegalArgumentException("Directory at " + String.valueOf(this.path) + " does not exist");
    }
}

