/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class UUIDUtils {
    private UUIDUtils() {
    }

    @NotNull
    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    @NotNull
    public static String generateUUID(String hint) {
        UUID uuid = UUID.nameUUIDFromBytes(hint.getBytes(StandardCharsets.UTF_8));
        return uuid.toString();
    }

    public static boolean isValidUUID(String uuid) {
        try {
            UUID.fromString(uuid);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

