/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.jetbrains.annotations.NotNull;

final class ChildOrderDiff {
    private ChildOrderDiff() {
    }

    static boolean isReordered(@NotNull PropertyState before, @NotNull PropertyState after) {
        Set<String> afterNames = SetUtils.toLinkedSet(after.getValue(Type.NAMES));
        Set<String> beforeNames = SetUtils.toLinkedSet(before.getValue(Type.NAMES));
        afterNames.retainAll(beforeNames);
        beforeNames.retainAll(afterNames);
        return !IterableUtils.elementsEqual(afterNames, beforeNames);
    }
}

