/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

public enum ConflictType {
    DELETE_CHANGED_PROPERTY("deleteChangedProperty", false),
    DELETE_CHANGED_NODE("deleteChangedNode", true),
    ADD_EXISTING_PROPERTY("addExistingProperty", false),
    CHANGE_DELETED_PROPERTY("changeDeletedProperty", false),
    CHANGE_CHANGED_PROPERTY("changeChangedProperty", false),
    DELETE_DELETED_PROPERTY("deleteDeletedProperty", false),
    ADD_EXISTING_NODE("addExistingNode", true),
    CHANGE_DELETED_NODE("changeDeletedNode", true),
    DELETE_DELETED_NODE("deleteDeletedNode", true);

    private final String name;
    private final boolean effectsNode;

    public String getName() {
        return this.name;
    }

    public boolean effectsNode() {
        return this.effectsNode;
    }

    public static ConflictType fromName(String name) {
        for (ConflictType t : ConflictType.values()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        throw new IllegalArgumentException("Unrecognized conflictType: " + name);
    }

    private ConflictType(String value, boolean node) {
        this.name = value;
        this.effectsNode = node;
    }
}

